/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.elaboration.constraints;

import java.io.Serializable;
import java.util.ArrayList;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.internal.elaboration.constraints.ConstraintEnvironment;
import org.simantics.scl.compiler.internal.elaboration.constraints.Reduction;
import org.simantics.scl.compiler.top.SCLCompilerConfiguration;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.util.Typed;
import org.simantics.scl.runtime.tuple.Tuple0;

public class Constraint
implements Typed {
    public static final Constraint[] EMPTY_ARRAY = new Constraint[0];
    public static final int STATE_UNSOLVED = 0;
    public static final int STATE_HAS_INSTANCE = 1;
    public static final int STATE_HAS_SUBCLASS = 2;
    public static final int STATE_GIVEN = 3;
    public static final Expression GIVEN_GENERATOR = new ELiteral(new Constant(Types.UNIT){

        @Override
        public Object realizeValue(TransientClassBuilder classBuilder) {
            return Tuple0.INSTANCE;
        }
    });
    public TPred constraint;
    int state = 0;
    public final Variable evidence;
    Expression generator;
    Type[] generatorParameters;
    Constraint[] dependsOn;
    boolean handled;
    long demandLocation;

    public Constraint(TPred constraint, Variable evidence, long demandLocation) {
        if (SCLCompilerConfiguration.DEBUG && (constraint == null || evidence == null)) {
            throw new NullPointerException();
        }
        this.constraint = constraint;
        this.evidence = evidence;
        this.demandLocation = demandLocation;
    }

    public void setGenerator(int newState, Expression generator, Type[] generatorParameters, Constraint ... dependsOn) {
        if (SCLCompilerConfiguration.DEBUG) {
            if (generator == null) {
                throw new NullPointerException();
            }
            Type[] typeArray = generatorParameters;
            int n = generatorParameters.length;
            int n2 = 0;
            while (n2 < n) {
                Type generatorParameter = typeArray[n2];
                if (generatorParameter == null) {
                    throw new NullPointerException();
                }
                ++n2;
            }
        }
        this.state = newState;
        this.generator = generator;
        this.dependsOn = dependsOn;
        this.generatorParameters = generatorParameters;
    }

    public Expression generate(long loc) {
        Expression result = this.generator;
        Serializable[] serializableArray = this.generatorParameters;
        int n = this.generatorParameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type p = serializableArray[n2];
            result = new EApplyType(loc, result, p);
            ++n2;
        }
        serializableArray = this.dependsOn;
        n = this.dependsOn.length;
        n2 = 0;
        while (n2 < n) {
            Serializable dep = serializableArray[n2];
            result = new EApply(loc, result, new EVariable(loc, ((Constraint)dep).evidence));
            ++n2;
        }
        return result;
    }

    public void collect(ConstraintEnvironment environment, ArrayList<Constraint> unsolvedConstraints, ArrayList<Constraint> solvedConstraints) {
        if (!this.handled) {
            switch (this.state) {
                case 0: {
                    unsolvedConstraints.add(this);
                    break;
                }
                case 2: {
                    Reduction reduction = environment.reduce(this.demandLocation, this.constraint);
                    if (reduction != null && reduction.demands.length == 0) {
                        this.generator = reduction.generator;
                        this.generatorParameters = reduction.parameters;
                        this.dependsOn = EMPTY_ARRAY;
                        this.state = 1;
                    }
                }
                case 1: {
                    Constraint[] constraintArray = this.dependsOn;
                    int n = this.dependsOn.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Constraint dep = constraintArray[n2];
                        dep.collect(environment, unsolvedConstraints, solvedConstraints);
                        ++n2;
                    }
                    solvedConstraints.add(this);
                }
            }
            this.handled = true;
        }
    }

    @Override
    public Type getType() {
        return this.constraint;
    }

    public long getDemandLocation() {
        return this.demandLocation;
    }
}

