/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.utils;

import org.simantics.scl.compiler.internal.codegen.utils.NameMangling;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TPred;

public class JavaNamingPolicy {
    private final String moduleName;
    private final String moduleClassName;
    int closureCount = 0;

    public JavaNamingPolicy(String moduleName) {
        this.moduleName = moduleName;
        this.moduleClassName = "scl/" + JavaNamingPolicy.moduleNameToClassName(moduleName);
    }

    private static boolean isAllowableClassNameChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '$';
    }

    public static String moduleNameToClassName(String moduleName) {
        StringBuilder b = new StringBuilder(moduleName.length());
        int length = moduleName.length();
        int i = 0;
        while (i < length) {
            char c = moduleName.charAt(i);
            if (c == '/' || JavaNamingPolicy.isAllowableClassNameChar(c)) {
                b.append(c);
            } else {
                b.append('_').append((int)c).append('_');
            }
            ++i;
        }
        return b.toString().replace("..", "._.").replace("//", "/_/");
    }

    public static String classNameToModuleName(String className) {
        className = className.replace("/_/", "//").replace("._.", "..");
        StringBuilder b = new StringBuilder(className.length());
        int length = className.length();
        int i = 0;
        while (i < length) {
            char c = className.charAt(i);
            if (c == '.') {
                b.append('/');
            } else if (c == '_') {
                StringBuilder nb = new StringBuilder(4);
                while (Character.isDigit(c = className.charAt(++i))) {
                    nb.append(c);
                }
                b.append((char)Integer.parseInt(nb.toString()));
            } else {
                b.append(c);
            }
            ++i;
        }
        return b.toString();
    }

    public String getModuleClassName() {
        return this.moduleClassName;
    }

    public String getMethodName(String name) {
        return NameMangling.mangle(name);
    }

    public String getFreshClosureClassNameSuffix() {
        return "$" + ++this.closureCount;
    }

    public String getFreshClosureClassName() {
        return this.moduleClassName + "$" + ++this.closureCount;
    }

    public String getDataTypeClassName(String name) {
        return this.moduleClassName + "$" + name;
    }

    public String getConstructorClassName(String name) {
        return this.moduleClassName + "$" + name + "Constructor";
    }

    public String getTypeClassInterfaceName(TCon name) {
        return this.moduleClassName + "$" + name.name + "Class";
    }

    public String getTypeClassInstanceClassName(String name) {
        return this.moduleClassName + "$" + name + "Instance";
    }

    public String getInstanceClassName(TPred instance) {
        return this.moduleClassName + "$" + instance.toName();
    }

    public String getModuleName() {
        return this.moduleName;
    }
}

