/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.ssa.exits;

import java.util.ArrayList;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.BooleanConstant;
import org.simantics.scl.compiler.constants.ComparisonFunction;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.continuations.ContRef;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAExit;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.ssa.binders.ValRefBinder;
import org.simantics.scl.compiler.internal.codegen.ssa.exits.Jump;
import org.simantics.scl.compiler.internal.codegen.ssa.statements.LetApply;
import org.simantics.scl.compiler.internal.codegen.utils.CopyContext;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.PrintingContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSAValidationContext;
import org.simantics.scl.compiler.internal.codegen.utils.ValRefVisitor;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class If
extends SSAExit
implements ValRefBinder {
    private ValRef condition;
    private ContRef thenTarget;
    private ContRef elseTarget;

    public If(int lineNumber, ValRef condition, ContRef thenTarget, ContRef elseTarget) {
        super(lineNumber);
        this.setCondition(condition);
        this.setThenTarget(thenTarget);
        this.setElseTarget(elseTarget);
    }

    public void setCondition(ValRef condition) {
        this.condition = condition;
        condition.setParent(this);
    }

    public void setThenTarget(ContRef thenTarget) {
        this.thenTarget = thenTarget;
        thenTarget.setParent(this);
    }

    public void setElseTarget(ContRef elseTarget) {
        this.elseTarget = elseTarget;
        elseTarget.setParent(this);
    }

    @Override
    public void generateCode(MethodBuilder mb) {
        mb.lineNumber(this.lineNumber);
        Val binding = this.condition.getBinding();
        if (binding instanceof BoundVar) {
            LetApply apply;
            Val function;
            BoundVar boundVar = (BoundVar)binding;
            if (boundVar.generateOnFly && (function = (apply = (LetApply)boundVar.getParent()).getFunction().getBinding()) instanceof ComparisonFunction) {
                Val[] ps = ValRef.getBindings(apply.getParameters());
                ((ComparisonFunction)((Object)function)).generateCondition(mb, ps, this.thenTarget.getBinding(), this.elseTarget.getBinding());
                return;
            }
        }
        mb.push(this.condition.getBinding(), Types.BOOLEAN);
        Label elseLabel = mb.getLabel(this.elseTarget.getBinding());
        mb.ifZeroComparisonBranch(elseLabel, "==");
        mb.jump(this.thenTarget.getBinding());
        mb.ensureExists(this.elseTarget.getBinding());
    }

    @Override
    public void toString(PrintingContext context) {
        context.append("if ");
        context.append(this.condition);
        context.append(" then ");
        Cont thenCont = this.thenTarget.getBinding();
        if (thenCont instanceof SSABlock) {
            SSABlock thenBlock = (SSABlock)thenCont;
            if (thenCont.hasMoreThanOneOccurences()) {
                context.append(thenCont);
                context.addBlock(thenBlock);
                context.append(' ');
            } else {
                context.append('\n');
                thenBlock.bodyToString(context);
                context.indentation();
            }
        } else {
            context.append(thenCont);
            context.append(' ');
        }
        context.append("else ");
        Cont elseCont = this.elseTarget.getBinding();
        if (elseCont instanceof SSABlock) {
            SSABlock elseBlock = (SSABlock)elseCont;
            if (elseCont.hasMoreThanOneOccurences()) {
                context.append(elseCont);
                context.addBlock(elseBlock);
                context.append('\n');
            } else {
                context.append('\n');
                elseBlock.bodyToString(context);
            }
        } else {
            context.append(elseCont);
            context.append('\n');
        }
    }

    @Override
    public void validate(SSAValidationContext context) {
        context.validate(this.condition);
        context.validate(this.elseTarget);
        context.validate(this.thenTarget);
        if (this.condition.getParent() != this) {
            throw new InternalCompilerError();
        }
        if (this.elseTarget.getParent() != this) {
            throw new InternalCompilerError();
        }
        if (this.thenTarget.getParent() != this) {
            throw new InternalCompilerError();
        }
        context.assertEquals(this, this.condition.getType(), Types.BOOLEAN);
        context.assertEquals(this.elseTarget.getBinding().getArity(), 0);
        context.assertEquals(this.thenTarget.getBinding().getArity(), 0);
    }

    @Override
    public void destroy() {
        this.condition.remove();
        this.elseTarget.remove();
        this.thenTarget.remove();
    }

    @Override
    public SSAExit copy(CopyContext context) {
        If copy = new If(this.lineNumber, context.copy(this.condition), context.copy(this.thenTarget), context.copy(this.elseTarget));
        return copy;
    }

    @Override
    public void replace(TVar[] vars, Type[] replacements) {
        this.condition.replace(vars, replacements);
    }

    @Override
    public void simplify(SSASimplificationContext context) {
        Val cond = this.condition.getBinding();
        if (cond instanceof BooleanConstant) {
            Jump newExit;
            if (((BooleanConstant)cond).getValue()) {
                newExit = new Jump(this.lineNumber, this.thenTarget, new ValRef[0]);
                this.elseTarget.remove();
            } else {
                newExit = new Jump(this.lineNumber, this.elseTarget, new ValRef[0]);
                this.thenTarget.remove();
            }
            this.condition.remove();
            this.getParent().setExit(newExit);
            context.markModified("beta-if");
        } else if (this.thenTarget.getBinding() == this.elseTarget.getBinding()) {
            this.elseTarget.remove();
            this.condition.remove();
            this.getParent().setExit(new Jump(this.lineNumber, this.thenTarget, new ValRef[0]));
            context.markModified("equal-branches-if");
        }
    }

    @Override
    public void collectFreeVariables(SSAFunction function, ArrayList<ValRef> vars) {
        this.condition.collectFreeVariables(function, vars);
    }

    @Override
    public Cont addParametersInFrontOf(ContRef contRef, Val[] newParameters, Val[] oldParameters, Cont proxy) {
        if (proxy == null) {
            proxy = contRef.getBinding().createProxy(this.getParent().getParent(), newParameters, oldParameters);
        }
        ContRef proxyRef = proxy.createOccurrence();
        if (this.thenTarget == contRef) {
            this.setThenTarget(proxyRef);
        } else {
            this.setElseTarget(proxyRef);
        }
        return proxy;
    }

    @Override
    public SSABlock[] getSuccessors() {
        Cont thenCont = this.thenTarget.getBinding();
        Cont elseCont = this.elseTarget.getBinding();
        if (thenCont instanceof SSABlock) {
            if (elseCont instanceof SSABlock) {
                return new SSABlock[]{(SSABlock)thenCont, (SSABlock)elseCont};
            }
            return new SSABlock[]{(SSABlock)thenCont};
        }
        if (elseCont instanceof SSABlock) {
            return new SSABlock[]{(SSABlock)elseCont};
        }
        return SSABlock.EMPTY_ARRAY;
    }

    @Override
    public void forValRefs(ValRefVisitor visitor) {
        visitor.visit(this.condition);
    }

    @Override
    public void cleanup() {
        this.condition.remove();
    }
}

