/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.chr;

import java.util.ArrayList;
import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.internal.codegen.chr.CHRCodeGenerationConstants;
import org.simantics.scl.compiler.internal.codegen.chr.CHRHashIndexCodeGenerator;
import org.simantics.scl.compiler.internal.codegen.chr.StoreInitialization;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.utils.ClassBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.LocalVariable;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilderBase;
import org.simantics.scl.compiler.internal.codegen.utils.ModuleBuilder;

public class CHRFactCodeGenerator
implements CHRCodeGenerationConstants {
    private ModuleBuilder moduleBuilder;
    private JavaTypeTranslator jtt;
    private ClassBuilder storeClassBuilder;
    private CHRRuleset ruleset;
    private CHRConstraint constraint;
    private String factClassName;
    private TypeDesc factTypeDesc;
    private ClassBuilder classBuilder;
    private TypeDesc storeTypeDesc;
    private TypeDesc[] storeTypeDescArray;
    private TypeDesc[] parameterTypeDescs;
    private boolean supportsRemoval;

    CHRFactCodeGenerator(ClassBuilder storeClassBuilder, CHRRuleset ruleset, CHRConstraint constraint) {
        this.storeClassBuilder = storeClassBuilder;
        this.ruleset = ruleset;
        this.constraint = constraint;
        this.moduleBuilder = storeClassBuilder.getModuleBuilder();
        this.jtt = this.moduleBuilder.getJavaTypeTranslator();
        this.storeTypeDesc = storeClassBuilder.getType();
        this.storeTypeDescArray = new TypeDesc[]{this.storeTypeDesc};
        this.factClassName = storeClassBuilder.getClassName() + "$" + constraint.name;
        this.factTypeDesc = TypeDesc.forClass(this.factClassName);
        this.classBuilder = new ClassBuilder(this.moduleBuilder, 1, this.factClassName, "org/simantics/scl/runtime/chr/CHRFact", new String[0]);
        this.parameterTypeDescs = this.jtt.toTypeDescs(constraint.parameterTypes);
        this.supportsRemoval = constraint.mayBeRemoved();
    }

    public void generate(ArrayList<StoreInitialization> hashIndexInitializations) {
        this.generateFields(hashIndexInitializations);
        hashIndexInitializations.add(new StoreInitialization(18, this.constraint.name + "$temp", this.factTypeDesc, this.factClassName));
        this.generateIndices();
        this.generateAdd();
        if (this.supportsRemoval) {
            this.generateRemove();
        }
        this.generateConstructor();
        this.classBuilder.addDefaultConstructor();
        this.moduleBuilder.addClass(this.classBuilder);
    }

    private void generateIndices() {
        for (CHRConstraint.IndexInfo indexInfo : this.constraint.getIndices()) {
            if (indexInfo.indexMask == 0) continue;
            ArrayList<TypeDesc> getParameterTypeDescs = new ArrayList<TypeDesc>(this.constraint.parameterTypes.length);
            int i = 0;
            while (i < this.constraint.parameterTypes.length) {
                if ((indexInfo.indexMask >> i & 1) == 1) {
                    getParameterTypeDescs.add(this.parameterTypeDescs[i]);
                }
                ++i;
            }
            MethodBuilderBase mb = this.storeClassBuilder.addMethodBase(1, this.constraint.name + "$" + indexInfo.indexName, this.factTypeDesc, getParameterTypeDescs.toArray(new TypeDesc[getParameterTypeDescs.size()]));
            mb.loadThis();
            mb.loadField(this.storeClassBuilder.getClassName(), this.constraint.name + "$temp", this.factTypeDesc);
            LocalVariable tempFactVar = mb.createLocalVariable("temp", this.factTypeDesc);
            mb.storeLocal(tempFactVar);
            int parameterId = 0;
            int i2 = 0;
            while (i2 < this.constraint.parameterTypes.length) {
                if ((indexInfo.indexMask >> i2 & 1) == 1) {
                    TypeDesc typeDesc = this.parameterTypeDescs[i2];
                    if (!typeDesc.equals(TypeDesc.VOID)) {
                        mb.loadLocal(tempFactVar);
                        mb.loadLocal(mb.getParameter(parameterId));
                        mb.storeField(this.factClassName, CHRCodeGenerationConstants.fieldName(i2), typeDesc);
                    }
                    ++parameterId;
                }
                ++i2;
            }
            mb.loadThis();
            mb.loadField(this.storeClassBuilder.getClassName(), this.constraint.name + "$" + indexInfo.indexName, CHRHashIndex);
            mb.loadLocal(tempFactVar);
            mb.invokeVirtual("org/simantics/scl/runtime/chr/CHRHashIndex", this.supportsRemoval ? "getEqual" : "getEqualNoRemovals", TypeDesc.OBJECT, Constants.OBJECTS[1]);
            mb.checkCast(this.factTypeDesc);
            mb.returnValue(this.factTypeDesc);
            mb.finish();
        }
    }

    private void generateConstructor() {
        ArrayList<TypeDesc> constructorParameters = new ArrayList<TypeDesc>(this.parameterTypeDescs.length + 1);
        constructorParameters.add(FACT_ID_TYPE);
        TypeDesc[] typeDescArray = this.parameterTypeDescs;
        int n = this.parameterTypeDescs.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDesc typeDesc = typeDescArray[n2];
            if (!typeDesc.equals(TypeDesc.VOID)) {
                constructorParameters.add(typeDesc);
            }
            ++n2;
        }
        MethodBuilderBase mb = this.classBuilder.addConstructorBase(1, constructorParameters.toArray(new TypeDesc[constructorParameters.size()]));
        mb.loadThis();
        mb.invokeConstructor(this.classBuilder.getSuperClassName(), Constants.EMPTY_TYPEDESC_ARRAY);
        mb.loadThis();
        mb.loadLocal(mb.getParameter(0));
        mb.storeField("org/simantics/scl/runtime/chr/CHRFact", "id", FACT_ID_TYPE);
        int i = 0;
        int parameterId = 1;
        while (i < this.constraint.parameterTypes.length) {
            TypeDesc typeDesc = this.parameterTypeDescs[i];
            if (!typeDesc.equals(TypeDesc.VOID)) {
                mb.loadThis();
                mb.loadLocal(mb.getParameter(parameterId++));
                mb.storeField(this.factClassName, CHRCodeGenerationConstants.fieldName(i), typeDesc);
            }
            ++i;
        }
        mb.returnVoid();
        mb.finish();
    }

    private void generateAdd() {
        MethodBuilderBase mb = this.classBuilder.addMethodBase(1, "add", TypeDesc.VOID, new TypeDesc[]{this.storeTypeDesc, CHRContext});
        LocalVariable storeParameter = mb.getParameter(0);
        for (CHRConstraint.IndexInfo indexInfo : this.constraint.getIndices()) {
            Label cont;
            String linkedListPrev = indexInfo.indexName + "Prev";
            String linkedListNext = indexInfo.indexName + "Next";
            String storeHashIndexName = this.constraint.name + "$" + indexInfo.indexName;
            if (indexInfo.indexMask == 0) {
                mb.loadThis();
                mb.loadLocal(storeParameter);
                mb.loadField(this.storeClassBuilder.getClassName(), storeHashIndexName, this.factTypeDesc);
                if (this.supportsRemoval) {
                    mb.dupX1();
                }
                mb.storeField(this.factClassName, linkedListNext, this.factTypeDesc);
                if (this.supportsRemoval) {
                    cont = new Label();
                    mb.ifNullBranch(cont, true);
                    mb.loadThis();
                    mb.loadField(this.factClassName, linkedListNext, this.factTypeDesc);
                    mb.loadThis();
                    mb.storeField(this.factClassName, linkedListPrev, this.factTypeDesc);
                    mb.setLocation(cont);
                }
                mb.loadLocal(storeParameter);
                mb.loadThis();
                mb.storeField(this.storeClassBuilder.getClassName(), storeHashIndexName, this.factTypeDesc);
                continue;
            }
            mb.loadThis();
            mb.loadLocal(storeParameter);
            mb.loadField(this.storeClassBuilder.getClassName(), storeHashIndexName, CHRHashIndex);
            mb.loadThis();
            mb.invokeVirtual("org/simantics/scl/runtime/chr/CHRHashIndex", this.supportsRemoval ? "addFreshAndReturnOld" : "addFreshAndReturnOld", TypeDesc.OBJECT, Constants.OBJECTS[1]);
            mb.checkCast(this.factTypeDesc);
            if (this.supportsRemoval) {
                mb.dupX1();
            }
            mb.storeField(this.factClassName, linkedListNext, this.factTypeDesc);
            if (!this.supportsRemoval) continue;
            cont = new Label();
            mb.ifNullBranch(cont, true);
            mb.loadThis();
            mb.loadField(this.factClassName, linkedListNext, this.factTypeDesc);
            mb.loadThis();
            mb.storeField(this.factClassName, linkedListPrev, this.factTypeDesc);
            mb.setLocation(cont);
        }
        int minimumPriority = this.ruleset.getMinimumPriority(this.constraint);
        if (minimumPriority != Integer.MAX_VALUE) {
            mb.loadLocal(storeParameter);
            mb.loadField(this.storeClassBuilder.getClassName(), CHRCodeGenerationConstants.priorityName(minimumPriority), CHRPriorityFactContainer);
            mb.loadLocal(mb.getParameter(1));
            mb.loadThis();
            mb.invokeVirtual("org/simantics/scl/runtime/chr/CHRPriorityFactContainer", "addFact", TypeDesc.VOID, new TypeDesc[]{CHRContext, CHRFact});
        } else if (this.constraint.nextContainerFieldName != null) {
            mb.loadLocal(storeParameter);
            mb.loadField(this.storeClassBuilder.getClassName(), this.constraint.nextContainerFieldName, CHRPriorityFactContainer);
            LocalVariable containerVar = mb.createLocalVariable("container", CHRPriorityFactContainer);
            mb.storeLocal(containerVar);
            mb.loadLocal(containerVar);
            Label finishLabel = mb.createLabel();
            mb.ifNullBranch(finishLabel, true);
            mb.loadLocal(containerVar);
            mb.loadLocal(mb.getParameter(1));
            mb.loadThis();
            mb.invokeVirtual("org/simantics/scl/runtime/chr/CHRPriorityFactContainer", "addFact", TypeDesc.VOID, new TypeDesc[]{CHRContext, CHRFact});
            mb.setLocation(finishLabel);
        }
        mb.returnVoid();
        mb.finish();
    }

    private void generateFields(ArrayList<StoreInitialization> hashIndexInitializations) {
        int i = 0;
        while (i < this.constraint.parameterTypes.length) {
            TypeDesc typeDesc = this.parameterTypeDescs[i];
            if (!typeDesc.equals(TypeDesc.VOID) && this.parameterTypeDescs[i] != TypeDesc.VOID) {
                this.classBuilder.addField(1, CHRCodeGenerationConstants.fieldName(i), typeDesc);
            }
            ++i;
        }
        for (CHRConstraint.IndexInfo indexInfo : this.constraint.getIndices()) {
            if (this.supportsRemoval) {
                this.classBuilder.addField(1, indexInfo.indexName + "Prev", this.factTypeDesc);
            }
            this.classBuilder.addField(1, indexInfo.indexName + "Next", this.factTypeDesc);
            String hashIndexField = this.constraint.name + "$" + indexInfo.indexName;
            if (indexInfo.indexMask == 0) {
                this.storeClassBuilder.addField(1, hashIndexField, this.factTypeDesc);
                continue;
            }
            ClassBuilder hashClass = CHRHashIndexCodeGenerator.generateHashIndex(this.storeClassBuilder, this.constraint, indexInfo, this.factTypeDesc, this.factClassName);
            this.moduleBuilder.addClass(hashClass);
            hashIndexInitializations.add(new StoreInitialization(17, hashIndexField, CHRHashIndex, hashClass.getClassName()));
        }
    }

    private void generateRemove() {
        MethodBuilderBase mb = this.classBuilder.addMethodBase(1, "remove", TypeDesc.VOID, this.storeTypeDescArray);
        LocalVariable storeParameter = mb.getParameter(0);
        for (CHRConstraint.IndexInfo indexInfo : this.constraint.getIndices()) {
            String linkedListPrev = indexInfo.indexName + "Prev";
            String linkedListNext = indexInfo.indexName + "Next";
            String storeHashIndexName = this.constraint.name + "$" + indexInfo.indexName;
            Label nextIndex = mb.createLabel();
            mb.loadThis();
            mb.loadField(this.factClassName, linkedListPrev, this.factTypeDesc);
            Label else1 = new Label();
            mb.ifNullBranch(else1, false);
            mb.loadThis();
            mb.loadField(this.factClassName, linkedListNext, this.factTypeDesc);
            Label else2 = new Label();
            mb.ifNullBranch(else2, false);
            if (indexInfo.indexMask == 0) {
                mb.loadLocal(storeParameter);
                mb.loadNull();
                mb.storeField(this.storeClassBuilder.getClassName(), storeHashIndexName, this.factTypeDesc);
            } else {
                mb.loadLocal(storeParameter);
                mb.loadField(this.storeClassBuilder.getClassName(), storeHashIndexName, CHRHashIndex);
                mb.loadThis();
                mb.invokeVirtual("org/simantics/scl/runtime/chr/CHRHashIndex", "removeKnownToExistKey", TypeDesc.VOID, Constants.OBJECTS[1]);
            }
            mb.branch(nextIndex);
            mb.setLocation(else2);
            mb.loadThis();
            mb.loadField(this.factClassName, linkedListNext, this.factTypeDesc);
            mb.loadNull();
            mb.storeField(this.factClassName, linkedListPrev, this.factTypeDesc);
            if (indexInfo.indexMask == 0) {
                mb.loadLocal(storeParameter);
                mb.loadThis();
                mb.loadField(this.factClassName, linkedListNext, this.factTypeDesc);
                mb.storeField(this.storeClassBuilder.getClassName(), storeHashIndexName, this.factTypeDesc);
            } else {
                mb.loadLocal(storeParameter);
                mb.loadField(this.storeClassBuilder.getClassName(), storeHashIndexName, CHRHashIndex);
                mb.loadThis();
                mb.loadThis();
                mb.loadField(this.factClassName, linkedListNext, this.factTypeDesc);
                mb.invokeVirtual("org/simantics/scl/runtime/chr/CHRHashIndex", "replaceKnownToExistKey", TypeDesc.VOID, Constants.OBJECTS[2]);
            }
            mb.branch(nextIndex);
            mb.setLocation(else1);
            mb.loadThis();
            mb.loadField(this.factClassName, linkedListPrev, this.factTypeDesc);
            mb.loadThis();
            mb.loadField(this.factClassName, linkedListNext, this.factTypeDesc);
            mb.storeField(this.factClassName, linkedListNext, this.factTypeDesc);
            mb.loadThis();
            mb.loadField(this.factClassName, linkedListNext, this.factTypeDesc);
            Label else3 = new Label();
            mb.ifNullBranch(else3, true);
            mb.loadThis();
            mb.loadField(this.factClassName, linkedListNext, this.factTypeDesc);
            mb.loadThis();
            mb.loadField(this.factClassName, linkedListPrev, this.factTypeDesc);
            mb.storeField(this.factClassName, linkedListPrev, this.factTypeDesc);
            mb.setLocation(else3);
            mb.branch(nextIndex);
            mb.setLocation(nextIndex);
        }
        mb.loadThis();
        mb.loadConstant(-1);
        mb.storeField("org/simantics/scl/runtime/chr/CHRFact", "id", FACT_ID_TYPE);
        mb.returnVoid();
        mb.finish();
    }
}

