/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.analysis;

public abstract class Dominance {
    int[] idom;

    public Dominance(int size) {
        this.idom = new int[size];
        this.idom[0] = 0;
        int i = 1;
        while (i < size) {
            this.idom[i] = -1;
            ++i;
        }
    }

    public void compute() {
        boolean changed;
        do {
            changed = true;
            int i = 1;
            while (i < this.idom.length) {
                int curDom = -1;
                int[] nArray = this.predecessors(i);
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int pred = nArray[n2];
                    int dom = this.idom[pred];
                    if (dom >= 0) {
                        curDom = curDom < 0 ? dom : this.intersect(dom, curDom);
                    }
                    ++n2;
                }
                if (this.idom[i] != curDom) {
                    this.idom[i] = curDom;
                    changed = true;
                }
                ++i;
            }
        } while (changed);
    }

    private int intersect(int a, int b) {
        while (a != b) {
            if (a < b) {
                b = this.idom[b];
                continue;
            }
            a = this.idom[a];
        }
        return a;
    }

    protected abstract int[] predecessors(int var1);
}

