/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.environment.specification;

import java.util.ArrayList;
import java.util.List;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.runtime.tuple.Tuple2;

public class EnvironmentSpecification {
    public final ArrayList<ImportDeclaration> imports = new ArrayList();

    public void importModule(String moduleName, String localName) {
        this.imports.add(new ImportDeclaration(moduleName, localName));
    }

    public static EnvironmentSpecification of(String ... strings) {
        if (strings.length % 2 != 0) {
            throw new IllegalArgumentException("Expected even number of parameters.");
        }
        EnvironmentSpecification spec = new EnvironmentSpecification();
        int i = 0;
        while (i < strings.length) {
            spec.importModule(strings[i], strings[i + 1]);
            i += 2;
        }
        return spec;
    }

    public static EnvironmentSpecification fromList(List<Tuple2> imports) {
        EnvironmentSpecification spec = new EnvironmentSpecification();
        for (Tuple2 tuple : imports) {
            spec.importModule((String)tuple.c0, (String)tuple.c1);
        }
        return spec;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.imports == null ? 0 : this.imports.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EnvironmentSpecification other = (EnvironmentSpecification)obj;
        return !(this.imports == null ? other.imports != null : !this.imports.equals(other.imports));
    }
}

