/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.environment.filter;

import gnu.trove.set.hash.THashSet;
import org.simantics.scl.compiler.environment.filter.AcceptAllNamespaceFilter;
import org.simantics.scl.compiler.environment.filter.NamespaceFilter;

public class PositiveNamespaceFilter
implements NamespaceFilter {
    THashSet<String> includedValues;

    public PositiveNamespaceFilter(THashSet<String> includedValues) {
        this.includedValues = includedValues;
    }

    @Override
    public boolean isValueIncluded(String name) {
        return this.includedValues.contains((Object)name);
    }

    public String toString() {
        return "Include" + this.includedValues.toString();
    }

    @Override
    public boolean isSubsetOf(NamespaceFilter filter) {
        if (filter == AcceptAllNamespaceFilter.INSTANCE) {
            return true;
        }
        for (String name : this.includedValues) {
            if (filter.isValueIncluded(name)) continue;
            return false;
        }
        return true;
    }
}

