/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.environment;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectProcedure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.rules.MappingRelation;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.environment.AmbiguousNameException;
import org.simantics.scl.compiler.environment.Namespace;
import org.simantics.scl.compiler.environment.filter.NamespaceFilter;
import org.simantics.scl.compiler.environment.filter.NamespaceFilters;
import org.simantics.scl.compiler.internal.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.types.TCon;

public class NamespaceImpl
implements Namespace {
    private final THashMap<String, Namespace> namespaceMap;
    private final ModuleImport[] moduleImports;

    public NamespaceImpl(THashMap<String, Namespace> namespaceMap, ModuleImport[] moduleImports) {
        this.namespaceMap = namespaceMap;
        this.moduleImports = moduleImports;
    }

    @Override
    public Namespace getNamespace(String name) {
        return (Namespace)this.namespaceMap.get((Object)name);
    }

    @Override
    public Collection<String> getNamespaces() {
        return this.namespaceMap.keySet();
    }

    @Override
    public SCLValue getValue(String name) throws AmbiguousNameException {
        SCLValue result = null;
        Module resultModule = null;
        ArrayList<String> conflictingModules = null;
        ModuleImport[] moduleImportArray = this.moduleImports;
        int n = this.moduleImports.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleImport moduleImport = moduleImportArray[n2];
            Module module = moduleImport.module;
            SCLValue temp = module.getValue(name);
            if (temp != null && !temp.isPrivate() && moduleImport.filter.isValueIncluded(name)) {
                if (result != null) {
                    if (conflictingModules == null) {
                        conflictingModules = new ArrayList<String>(2);
                        conflictingModules.add(resultModule.getName());
                    }
                    conflictingModules.add(module.getName());
                } else {
                    result = temp;
                    resultModule = module;
                }
            }
            ++n2;
        }
        if (conflictingModules != null) {
            throw new AmbiguousNameException(conflictingModules, name);
        }
        return result;
    }

    @Override
    public SCLRelation getRelation(String name) throws AmbiguousNameException {
        SCLRelation result = null;
        Module resultModule = null;
        ArrayList<String> conflictingModules = null;
        ModuleImport[] moduleImportArray = this.moduleImports;
        int n = this.moduleImports.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleImport moduleImport = moduleImportArray[n2];
            Module module = moduleImport.module;
            SCLRelation temp = module.getRelation(name);
            if (temp != null) {
                if (result != null) {
                    if (conflictingModules == null) {
                        conflictingModules = new ArrayList<String>(2);
                        conflictingModules.add(resultModule.getName());
                    }
                    conflictingModules.add(module.getName());
                } else {
                    result = temp;
                    resultModule = module;
                }
            }
            ++n2;
        }
        if (conflictingModules != null) {
            throw new AmbiguousNameException(conflictingModules, name);
        }
        return result;
    }

    @Override
    public SCLEntityType getEntityType(String name) throws AmbiguousNameException {
        SCLEntityType result = null;
        Module resultModule = null;
        ArrayList<String> conflictingModules = null;
        ModuleImport[] moduleImportArray = this.moduleImports;
        int n = this.moduleImports.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleImport moduleImport = moduleImportArray[n2];
            Module module = moduleImport.module;
            SCLEntityType temp = module.getEntityType(name);
            if (temp != null) {
                if (result != null) {
                    if (conflictingModules == null) {
                        conflictingModules = new ArrayList<String>(2);
                        conflictingModules.add(resultModule.getName());
                    }
                    conflictingModules.add(module.getName());
                } else {
                    result = temp;
                    resultModule = module;
                }
            }
            ++n2;
        }
        if (conflictingModules != null) {
            throw new AmbiguousNameException(conflictingModules, name);
        }
        return result;
    }

    @Override
    public TypeDescriptor getTypeDescriptor(String name) throws AmbiguousNameException {
        TypeDescriptor result = null;
        Module resultModule = null;
        ArrayList<String> conflictingModules = null;
        ModuleImport[] moduleImportArray = this.moduleImports;
        int n = this.moduleImports.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleImport moduleImport = moduleImportArray[n2];
            Module module = moduleImport.module;
            TypeDescriptor temp = module.getTypeDescriptor(name);
            if (temp != null) {
                if (result != null) {
                    if (conflictingModules == null) {
                        conflictingModules = new ArrayList<String>(2);
                        conflictingModules.add(resultModule.getName());
                    }
                    conflictingModules.add(module.getName());
                } else {
                    result = temp;
                    resultModule = module;
                }
            }
            ++n2;
        }
        if (conflictingModules != null) {
            throw new AmbiguousNameException(conflictingModules, name);
        }
        return result;
    }

    @Override
    public EffectConstructor getEffectConstructor(String name) throws AmbiguousNameException {
        EffectConstructor result = null;
        Module resultModule = null;
        ArrayList<String> conflictingModules = null;
        ModuleImport[] moduleImportArray = this.moduleImports;
        int n = this.moduleImports.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleImport moduleImport = moduleImportArray[n2];
            Module module = moduleImport.module;
            EffectConstructor temp = module.getEffectConstructor(name);
            if (temp != null) {
                if (result != null) {
                    if (conflictingModules == null) {
                        conflictingModules = new ArrayList<String>(2);
                        conflictingModules.add(resultModule.getName());
                    }
                    conflictingModules.add(module.getName());
                } else {
                    result = temp;
                    resultModule = module;
                }
            }
            ++n2;
        }
        if (conflictingModules != null) {
            throw new AmbiguousNameException(conflictingModules, name);
        }
        return result;
    }

    @Override
    public TypeClass getTypeClass(String name) throws AmbiguousNameException {
        TypeClass result = null;
        Module resultModule = null;
        ArrayList<String> conflictingModules = null;
        ModuleImport[] moduleImportArray = this.moduleImports;
        int n = this.moduleImports.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleImport moduleImport = moduleImportArray[n2];
            Module module = moduleImport.module;
            TypeClass temp = module.getTypeClass(name);
            if (temp != null) {
                if (result != null) {
                    if (conflictingModules == null) {
                        conflictingModules = new ArrayList<String>(2);
                        conflictingModules.add(resultModule.getName());
                    }
                    conflictingModules.add(module.getName());
                } else {
                    result = temp;
                    resultModule = module;
                }
            }
            ++n2;
        }
        if (conflictingModules != null) {
            throw new AmbiguousNameException(conflictingModules, name);
        }
        return result;
    }

    @Override
    public MappingRelation getMappingRelation(String name) throws AmbiguousNameException {
        MappingRelation result = null;
        Module resultModule = null;
        ArrayList<String> conflictingModules = null;
        ModuleImport[] moduleImportArray = this.moduleImports;
        int n = this.moduleImports.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleImport moduleImport = moduleImportArray[n2];
            Module module = moduleImport.module;
            MappingRelation temp = module.getMappingRelation(name);
            if (temp != null) {
                if (result != null) {
                    if (conflictingModules == null) {
                        conflictingModules = new ArrayList<String>(2);
                        conflictingModules.add(resultModule.getName());
                    }
                    conflictingModules.add(module.getName());
                } else {
                    result = temp;
                    resultModule = module;
                }
            }
            ++n2;
        }
        if (conflictingModules != null) {
            throw new AmbiguousNameException(conflictingModules, name);
        }
        return result;
    }

    @Override
    public TransformationRule getRule(String name) throws AmbiguousNameException {
        TransformationRule result = null;
        Module resultModule = null;
        ArrayList<String> conflictingModules = null;
        ModuleImport[] moduleImportArray = this.moduleImports;
        int n = this.moduleImports.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleImport moduleImport = moduleImportArray[n2];
            Module module = moduleImport.module;
            TransformationRule temp = module.getRule(name);
            if (temp != null) {
                if (result != null) {
                    if (conflictingModules == null) {
                        conflictingModules = new ArrayList<String>(2);
                        conflictingModules.add(resultModule.getName());
                    }
                    conflictingModules.add(module.getName());
                } else {
                    result = temp;
                    resultModule = module;
                }
            }
            ++n2;
        }
        if (conflictingModules != null) {
            throw new AmbiguousNameException(conflictingModules, name);
        }
        return result;
    }

    @Override
    public CHRRuleset getRuleset(String name) throws AmbiguousNameException {
        CHRRuleset result = null;
        Module resultModule = null;
        ArrayList<String> conflictingModules = null;
        ModuleImport[] moduleImportArray = this.moduleImports;
        int n = this.moduleImports.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleImport moduleImport = moduleImportArray[n2];
            Module module = moduleImport.module;
            CHRRuleset temp = module.getRuleset(name);
            if (temp != null) {
                if (result != null) {
                    if (conflictingModules == null) {
                        conflictingModules = new ArrayList<String>(2);
                        conflictingModules.add(resultModule.getName());
                    }
                    conflictingModules.add(module.getName());
                } else {
                    result = temp;
                    resultModule = module;
                }
            }
            ++n2;
        }
        if (conflictingModules != null) {
            throw new AmbiguousNameException(conflictingModules, name);
        }
        return result;
    }

    @Override
    public void findValuesForPrefix(String prefix, NamespaceFilter filter, TObjectProcedure<SCLValue> proc) {
        ModuleImport[] moduleImportArray = this.moduleImports;
        int n = this.moduleImports.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleImport moduleImport = moduleImportArray[n2];
            moduleImport.module.findValuesForPrefix(prefix, NamespaceFilters.intersection(filter, moduleImport.filter), proc);
            ++n2;
        }
    }

    @Override
    public void findTypesForPrefix(String prefix, NamespaceFilter filter, Consumer<TCon> consumer) {
        ModuleImport[] moduleImportArray = this.moduleImports;
        int n = this.moduleImports.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleImport moduleImport = moduleImportArray[n2];
            moduleImport.module.findTypesForPrefix(prefix, NamespaceFilters.intersection(filter, moduleImport.filter), consumer);
            ++n2;
        }
    }

    public static class ModuleImport {
        public final Module module;
        public NamespaceFilter filter;

        public ModuleImport(Module module, NamespaceFilter filter) {
            this.module = module;
            this.filter = filter;
        }
    }
}

