/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.environment;

import java.util.Arrays;
import java.util.Collection;

public class AmbiguousNameException
extends Exception {
    private static final long serialVersionUID = 1448746846203589730L;
    public final String[] conflictingModules;
    public final String name;

    public AmbiguousNameException(Collection<String> conflictingModules, String name) {
        this.conflictingModules = conflictingModules.toArray(new String[conflictingModules.size()]);
        Arrays.sort(this.conflictingModules);
        this.name = name;
    }

    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }

    @Override
    public String getMessage() {
        StringBuilder b = new StringBuilder();
        b.append("Ambiguous reference to " + this.name + ". It can be found from modules ");
        int i = 0;
        while (i < this.conflictingModules.length) {
            if (i > 0) {
                if (i == this.conflictingModules.length - 1) {
                    b.append(" and ");
                } else {
                    b.append(", ");
                }
            }
            b.append(this.conflictingModules[i]);
            ++i;
        }
        b.append('.');
        return b.toString();
    }
}

