/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.relations;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.relations.AbstractRelation;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class LocalRelation
extends AbstractRelation {
    String name;
    Type[] parameterTypes;
    public Variable table;

    public LocalRelation(String name, int arity) {
        this.name = name;
        this.parameterTypes = new Type[arity];
        int i = 0;
        while (i < arity) {
            this.parameterTypes[i] = Types.metaVar(Kinds.STAR);
            ++i;
        }
        this.createTable();
    }

    public LocalRelation(String name, Type[] parameterTypes) {
        this.name = name;
        this.parameterTypes = parameterTypes;
        this.createTable();
    }

    private void createTable() {
        this.table = Expressions.newVar("table" + this.name, Types.apply((Type)Names.MSet_T, Types.tuple(this.parameterTypes)));
    }

    public int getArity() {
        return this.parameterTypes.length;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public TVar[] getTypeVariables() {
        return TVar.EMPTY_ARRAY;
    }

    @Override
    public Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public double getSelectivity(int boundVariabes) {
        double s = 0.95;
        int i = 0;
        while (i < this.parameterTypes.length) {
            if ((boundVariabes & 1) == 0) {
                s *= 10.0;
            }
            ++i;
            boundVariabes >>= 1;
        }
        return s;
    }

    @Override
    public int getRequiredVariablesMask() {
        return 0;
    }

    @Override
    public void generate(long location, QueryCompilationContext context, Type[] typeParameters, Variable[] parameters, int boundVariables) {
        if (this.table == null) {
            throw new InternalCompilerError(location, "Variable table is undefined.");
        }
        if (boundVariables + 1 == 1 << parameters.length) {
            context.condition(Expressions.apply((EnvironmentalContext)context.getCompilationContext(), (Type)Types.PROC, Names.MSet_contains, Types.tuple(this.parameterTypes), Expressions.var(this.table), Expressions.tuple(Expressions.vars(parameters))));
        } else {
            Variable[] aux = new Variable[parameters.length];
            int i = 0;
            while (i < parameters.length) {
                aux[i] = (boundVariables >> i & 1) == 1 ? new Variable("aux_" + parameters[i].getName(), parameters[i].getType()) : parameters[i];
                ++i;
            }
            Variable row = new Variable("row", Types.tuple(this.parameterTypes));
            int i2 = 0;
            while (i2 < parameters.length) {
                if ((boundVariables >> i2 & 1) == 1) {
                    context.condition(Expressions.apply((EnvironmentalContext)context.getCompilationContext(), (Type)Types.NO_EFFECTS, Names.Builtin_equals, this.parameterTypes[i2], Expressions.var(aux[i2]), Expressions.var(parameters[i2])));
                }
                ++i2;
            }
            context.match(Expressions.tuple(Expressions.vars(aux)), new EVariable(row), false);
            context.iterateMSet(row, new EVariable(this.table));
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Type getEnforceEffect() {
        return Types.PROC;
    }

    @Override
    public Type getQueryEffect() {
        return Types.PROC;
    }
}

