/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Set;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.QueryTransformer;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.elaboration.expressions.printing.ExpressionToStringVisitor;
import org.simantics.scl.compiler.elaboration.expressions.visitors.CollectRefsVisitor;
import org.simantics.scl.compiler.elaboration.expressions.visitors.CollectVarsVisitor;
import org.simantics.scl.compiler.elaboration.expressions.visitors.ForVariablesUsesVisitor;
import org.simantics.scl.compiler.elaboration.expressions.visitors.StandardExpressionVisitor;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.query.QDisjunction;
import org.simantics.scl.compiler.elaboration.query.QueryVisitor;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;
import org.simantics.scl.compiler.elaboration.query.compilation.DerivateException;
import org.simantics.scl.compiler.elaboration.query.compilation.DynamicProgrammingOrdering;
import org.simantics.scl.compiler.elaboration.query.compilation.EnforcingContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryConstraint;
import org.simantics.scl.compiler.elaboration.query.compilation.UnsolvableQueryException;
import org.simantics.scl.compiler.elaboration.relations.CompositeRelation;
import org.simantics.scl.compiler.elaboration.relations.LocalRelation;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.internal.parsing.Symbol;

public abstract class Query
extends Symbol {
    public static final Query[] EMPTY_ARRAY = new Query[0];
    protected static final TIntObjectHashMap<ArrayList<Query>> NO_DERIVATE = new TIntObjectHashMap();
    public static final Diff[] NO_DIFF = new Diff[0];
    public static final QDisjunction EMPTY_QUERY = new QDisjunction(new Query[0]);

    public abstract void checkType(TypingContext var1);

    public Query resolve(TranslationContext context) {
        throw new InternalCompilerError(this.location, this.getClass().getSimpleName() + " does not support resolve.");
    }

    public Expression generateEnforce(EnforcingContext context) {
        context.getErrorLog().log(this.location, this.getClass().getSimpleName() + " does not support enforcing.");
        return new EError(this.location);
    }

    public abstract void collectConstraints(ConstraintCollectionContext var1) throws UnsolvableQueryException;

    protected QueryConstraint[] getOrderedConstraints(QueryCompilationContext context) throws UnsolvableQueryException {
        ConstraintCollectionContext collectionContext = new ConstraintCollectionContext(context);
        this.collectConstraints(collectionContext);
        QueryConstraint[] constraints = collectionContext.getConstraints();
        DynamicProgrammingOrdering.order(collectionContext, constraints, 0L);
        return constraints;
    }

    protected void applyConstraints(QueryCompilationContext context, QueryConstraint[] constraints) {
        int i = constraints.length - 1;
        while (i >= 0) {
            constraints[i].generateAndUpdateCost(context);
            --i;
        }
    }

    public void generate(QueryCompilationContext context) throws UnsolvableQueryException {
        this.applyConstraints(context, this.getOrderedConstraints(context));
    }

    public Diff[] derivate(THashMap<LocalRelation, Diffable> diffables) throws DerivateException {
        throw new DerivateException(this.location);
    }

    public Query removeRelations(Set<SCLRelation> relations) {
        throw new UnsupportedOperationException();
    }

    public Query copy() {
        return this.replace(new ReplaceContext(null));
    }

    public Query copy(TypingContext context) {
        return this.replace(new ReplaceContext(context));
    }

    public abstract Query replace(ReplaceContext var1);

    public abstract void setLocationDeep(long var1);

    public abstract void accept(QueryVisitor var1);

    public void collectRelationRefs(final TObjectIntHashMap<SCLRelation> allRefs, final TIntHashSet refs) {
        this.accept(new StandardExpressionVisitor(){

            @Override
            public void visit(QAtom query) {
                this.visit(query.relation);
            }

            private void visit(SCLRelation relation) {
                int id = allRefs.get((Object)relation);
                if (id >= 0) {
                    refs.add(id);
                } else if (relation instanceof CompositeRelation) {
                    SCLRelation[] sCLRelationArray = ((CompositeRelation)relation).getSubrelations();
                    int n = sCLRelationArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SCLRelation subrelation = sCLRelationArray[n2];
                        this.visit(subrelation);
                        ++n2;
                    }
                }
            }
        });
    }

    public TIntObjectHashMap<ArrayList<Query>> splitToPhases() {
        TIntObjectHashMap result = new TIntObjectHashMap(2);
        this.splitToPhases((TIntObjectHashMap<ArrayList<Query>>)result);
        return result;
    }

    public void splitToPhases(TIntObjectHashMap<ArrayList<Query>> result) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + " does not support splitToPhases.");
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        ExpressionToStringVisitor visitor = new ExpressionToStringVisitor(b);
        this.accept(visitor);
        return b.toString();
    }

    public abstract Query accept(QueryTransformer var1);

    public void forVariables(VariableProcedure procedure) {
        this.accept(new ForVariablesUsesVisitor(procedure));
    }

    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        this.accept(new CollectRefsVisitor(allRefs, refs));
    }

    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.accept(new CollectVarsVisitor(allVars, vars));
    }

    public static class Diff {
        public int id;
        public Query query;

        public Diff(int id, Query query) {
            this.id = id;
            this.query = query;
        }
    }

    public static class Diffable {
        public int id;
        SCLRelation relation;
        public Variable[] parameters;

        public Diffable(int id, SCLRelation relation, Variable[] parameters) {
            this.id = id;
            this.relation = relation;
            this.parameters = parameters;
        }
    }
}

