/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Set;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.QueryTransformer;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.elaboration.java.EqRelation;
import org.simantics.scl.compiler.elaboration.query.QConjunction;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.QueryVisitor;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;
import org.simantics.scl.compiler.elaboration.query.compilation.DerivateException;
import org.simantics.scl.compiler.elaboration.query.compilation.EnforcingContext;
import org.simantics.scl.compiler.elaboration.query.compilation.ExpressionConstraint;
import org.simantics.scl.compiler.elaboration.query.compilation.RelationConstraint;
import org.simantics.scl.compiler.elaboration.relations.CompositeRelation;
import org.simantics.scl.compiler.elaboration.relations.LocalRelation;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class QAtom
extends Query {
    public SCLRelation relation;
    public Type[] typeParameters;
    public Expression[] parameters;

    public QAtom(SCLRelation relation, Expression ... parameters) {
        this.relation = relation;
        this.parameters = parameters;
    }

    public QAtom(SCLRelation relation, Type[] typeParameters, Expression ... parameters) {
        this.relation = relation;
        this.typeParameters = typeParameters;
        this.parameters = parameters;
    }

    @Override
    public void checkType(TypingContext context) {
        TVar[] typeVariables = this.relation.getTypeVariables();
        this.typeParameters = new Type[typeVariables.length];
        int i = 0;
        while (i < typeVariables.length) {
            this.typeParameters[i] = Types.metaVar(typeVariables[i].getKind());
            ++i;
        }
        Type[] parameterTypes = this.relation.getParameterTypes();
        if (parameterTypes.length != this.parameters.length) {
            context.getErrorLog().log(this.location, "Relation is applied with wrong number of parameters.");
        } else {
            int i2 = 0;
            while (i2 < this.parameters.length) {
                this.parameters[i2] = this.parameters[i2].checkType(context, parameterTypes[i2].replace(typeVariables, this.typeParameters));
                ++i2;
            }
        }
    }

    @Override
    public Expression generateEnforce(EnforcingContext context) {
        Variable[] variables = new Variable[this.parameters.length];
        int i = 0;
        while (i < variables.length) {
            variables[i] = this.parameters[i] instanceof EVariable ? ((EVariable)this.parameters[i]).getVariable() : new Variable("p" + i, this.parameters[i].getType());
            ++i;
        }
        Expression result = this.relation.generateEnforce(this.location, context, this.typeParameters, variables);
        int i2 = variables.length - 1;
        while (i2 >= 0) {
            if (!(this.parameters[i2] instanceof EVariable)) {
                result = new ESimpleLet(variables[i2], this.parameters[i2], result);
            }
            --i2;
        }
        return result;
    }

    @Override
    public void collectConstraints(ConstraintCollectionContext context) {
        try {
            VariableMaskProcedure procedure = new VariableMaskProcedure(context);
            int[] optionalVariableByParameter = new int[this.parameters.length];
            Variable[] varParameters = new Variable[this.parameters.length];
            int i = 0;
            while (i < this.parameters.length) {
                Expression parameter = this.parameters[i];
                if (parameter instanceof EVariable) {
                    Variable variable = ((EVariable)parameter).getVariable();
                    optionalVariableByParameter[i] = context.getVariableMap().get((Object)variable);
                    varParameters[i] = variable;
                } else {
                    Variable temp;
                    varParameters[i] = temp = new Variable("temp", parameter.getType());
                    if (parameter.isPattern(0)) {
                        int tempId = context.addVariable(temp);
                        context.addConstraint(new ExpressionConstraint(context, temp, parameter, true));
                        optionalVariableByParameter[i] = tempId;
                    } else {
                        optionalVariableByParameter[i] = -1;
                        parameter.forVariableUses(procedure);
                    }
                }
                ++i;
            }
            TIntHashSet allVariablesSet = new TIntHashSet();
            int[] nArray = optionalVariableByParameter;
            int n = optionalVariableByParameter.length;
            int n2 = 0;
            while (n2 < n) {
                int v = nArray[n2];
                if (v >= 0) {
                    allVariablesSet.add(v);
                }
                ++n2;
            }
            context.addConstraint(new RelationConstraint(allVariablesSet.toArray(), varParameters, this, optionalVariableByParameter, procedure.requiredVariablesMask));
        }
        catch (Exception e) {
            context.getQueryCompilationContext().getTypingContext().getErrorLog().log(this.location, e);
        }
    }

    @Override
    public Query replace(ReplaceContext context) {
        Type[] newTypeParameters;
        if (this.typeParameters == null) {
            newTypeParameters = null;
        } else {
            newTypeParameters = new Type[this.typeParameters.length];
            int i = 0;
            while (i < this.typeParameters.length) {
                newTypeParameters[i] = this.typeParameters[i].replace(context.tvarMap);
                ++i;
            }
        }
        return new QAtom(this.relation, newTypeParameters, Expression.replace(context, this.parameters));
    }

    @Override
    public Query.Diff[] derivate(THashMap<LocalRelation, Query.Diffable> diffables) throws DerivateException {
        Query.Diffable diffable = (Query.Diffable)diffables.get((Object)this.relation);
        if (diffable == null) {
            if (this.relation instanceof CompositeRelation && QAtom.containsReferenceTo((CompositeRelation)this.relation, diffables)) {
                throw new DerivateException(this.location);
            }
            return NO_DIFF;
        }
        Query[] eqs = new Query[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            QAtom eq = new QAtom((SCLRelation)EqRelation.INSTANCE, new EVariable(diffable.parameters[i]), this.parameters[i]);
            eq.setLocationDeep(this.location);
            eq.typeParameters = new Type[]{this.parameters[i].getType()};
            eqs[i] = eq;
            ++i;
        }
        return new Query.Diff[]{new Query.Diff(diffable.id, new QConjunction(eqs))};
    }

    private static boolean containsReferenceTo(CompositeRelation relation, THashMap<SCLRelation, Query.Diffable> diffables) {
        SCLRelation[] sCLRelationArray = relation.getSubrelations();
        int n = sCLRelationArray.length;
        int n2 = 0;
        while (n2 < n) {
            SCLRelation r = sCLRelationArray[n2];
            if (diffables.containsKey((Object)r)) {
                return true;
            }
            if (r instanceof CompositeRelation && QAtom.containsReferenceTo((CompositeRelation)r, diffables)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public Query removeRelations(Set<SCLRelation> relations) {
        if (relations.contains(this.relation)) {
            return EMPTY_QUERY;
        }
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            Expression[] expressionArray = this.parameters;
            int n = this.parameters.length;
            int n2 = 0;
            while (n2 < n) {
                Expression parameter = expressionArray[n2];
                parameter.setLocationDeep(loc);
                ++n2;
            }
        }
    }

    @Override
    public void accept(QueryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void splitToPhases(TIntObjectHashMap<ArrayList<Query>> result) {
        int phase = this.relation.getPhase();
        ArrayList<QAtom> list = (ArrayList<QAtom>)result.get(phase);
        if (list == null) {
            list = new ArrayList<QAtom>();
            result.put(phase, list);
        }
        list.add(this);
    }

    @Override
    public Query accept(QueryTransformer transformer) {
        return transformer.transform(this);
    }

    private static class VariableMaskProcedure
    implements VariableProcedure {
        ConstraintCollectionContext context;
        long requiredVariablesMask = 0L;

        public VariableMaskProcedure(ConstraintCollectionContext context) {
            this.context = context;
        }

        @Override
        public void execute(long location, Variable variable) {
            int id = this.context.getVariableMap().get((Object)variable);
            if (id >= 0) {
                this.requiredVariablesMask |= 1L << id;
            }
        }
    }
}

