/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions.visitors;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ETransformation;
import org.simantics.scl.compiler.elaboration.expressions.visitors.StandardExpressionVisitor;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.relations.CompositeRelation;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;

public class CollectRefsVisitor
extends StandardExpressionVisitor {
    private final TObjectIntHashMap<Object> allRefs;
    private final TIntHashSet refs;

    public CollectRefsVisitor(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        this.allRefs = allRefs;
        this.refs = refs;
    }

    @Override
    public void visit(ETransformation expression) {
        int ref = this.allRefs.get(ETransformation.TRANSFORMATION_RULES_TYPECHECKED);
        if (ref >= 0) {
            this.refs.add(ref);
        }
        super.visit(expression);
    }

    @Override
    public void visit(EConstant expression) {
        int id = this.allRefs.get((Object)expression.value);
        if (id >= 0) {
            this.refs.add(id);
        }
    }

    @Override
    public void visit(QAtom query) {
        this.collectRelationRefs(query.relation);
        super.visit(query);
    }

    private void collectRelationRefs(SCLRelation relation) {
        if (relation instanceof CompositeRelation) {
            SCLRelation[] sCLRelationArray = ((CompositeRelation)relation).getSubrelations();
            int n = sCLRelationArray.length;
            int n2 = 0;
            while (n2 < n) {
                SCLRelation subrelation = sCLRelationArray[n2];
                this.collectRelationRefs(subrelation);
                ++n2;
            }
        } else {
            int id = this.allRefs.get((Object)relation);
            if (id >= 0) {
                this.refs.add(id);
            }
        }
    }
}

