/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions.annotations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.simantics.scl.compiler.constants.StringConstant;
import org.simantics.scl.compiler.elaboration.expressions.EListLiteral;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EStringLiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.parsing.declarations.DAnnotationAst;

public class AnnotationUtils {
    public static String processStringAnnotation(ErrorLog errorLog, DAnnotationAst annotation) {
        String result;
        if (annotation.parameters.length != 1) {
            errorLog.log(annotation.location, "Expected one string parameter for " + annotation.id.text);
        }
        if ((result = AnnotationUtils.extractString(annotation.parameters[0])) == null) {
            errorLog.log(annotation.location, "Expected a string parameter for " + annotation.id.text);
        }
        return result;
    }

    public static void processTagAnnotation(ErrorLog errorLog, DAnnotationAst annotation) {
        if (annotation.parameters.length != 0) {
            errorLog.log(annotation.location, "Expected no parameters for " + annotation.id.text);
        }
    }

    public static String extractString(Expression expression) {
        ELiteral literal;
        if (expression instanceof EVar) {
            return ((EVar)expression).name;
        }
        if (expression instanceof EStringLiteral) {
            EStringLiteral literal2 = (EStringLiteral)expression;
            if (literal2.strings.length == 1) {
                return literal2.strings[0];
            }
        } else if (expression instanceof ELiteral && (literal = (ELiteral)expression).getValue() instanceof StringConstant) {
            StringConstant constant = (StringConstant)literal.getValue();
            return constant.getValue();
        }
        return null;
    }

    public static List<EVar> extractIdentifierList(Expression expression) {
        if (expression instanceof EVar || expression instanceof EStringLiteral || expression instanceof ELiteral) {
            return Collections.singletonList(new EVar(expression.location, AnnotationUtils.extractString(expression)));
        }
        if (expression instanceof EListLiteral) {
            Expression[] components = ((EListLiteral)expression).getComponents();
            EVar[] items = new EVar[components.length];
            int i = 0;
            while (i < components.length) {
                String value = AnnotationUtils.extractString(components[i]);
                if (value == null) {
                    return null;
                }
                items[i] = new EVar(components[i].location, value);
                ++i;
            }
            return Arrays.asList(items);
        }
        return null;
    }
}

