/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.internal.interpreted.IVariable;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public class EVariable
extends Expression {
    public static final EVariable[] EMPTY_ARRAY = new EVariable[0];
    public Variable variable;

    public EVariable(Variable variable) {
        this.variable = variable;
    }

    public EVariable(long loc, Variable variable) {
        super(loc);
        this.variable = variable;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public void setVariable(Variable variable) {
        this.variable = variable;
    }

    @Override
    public Set<Variable> getFreeVariables() {
        if (this.variable == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.variable);
    }

    public void toString(StringBuilder b, TypeUnparsingContext tuc) {
        b.append(this.variable == null ? "???" : this.variable.toString());
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.variable.getType());
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        return this.variable.getVal();
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        Expression expression = context.getInlinedValue(this.variable);
        if (expression != null) {
            return expression.copy();
        }
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return this;
    }

    @Override
    public void getParameters(TranslationContext translationContext, ArrayList<Expression> parameters) {
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        return this;
    }

    @Override
    public Expression replace(ReplaceContext context) {
        if (context.inPattern) {
            Type type = this.variable.getType().replace(context.tvarMap);
            Variable newVariable = new Variable(this.variable.name);
            newVariable.setType(type);
            EVariable result = new EVariable(newVariable);
            context.varMap.put((Object)this.variable, (Object)result);
            return result;
        }
        if (this.variable == null) {
            EVariable newVariable = new EVariable(this.location, null);
            newVariable.setType(this.getType().replace(context.tvarMap));
            if (context.typingContext == null) {
                throw new InternalCompilerError(this.location, "Encountered unresolved variable but not in type checking phase.");
            }
            context.typingContext.addConstraintDemand(newVariable);
            return newVariable;
        }
        Expression expression = (Expression)context.varMap.get((Object)this.variable);
        if (expression != null) {
            return expression.copy(context.typingContext);
        }
        return new EVariable(this.variable);
    }

    @Override
    public IExpression toIExpression(ExpressionInterpretationContext target) {
        return new IVariable(target.getVariableId(this.variable));
    }

    @Override
    public Expression inferType(TypingContext context) {
        if (context.isInPattern()) {
            this.variable.setType(Types.metaVar(Kinds.STAR));
            return this;
        }
        if (this.variable.getType() == null) {
            context.getErrorLog().log(this.location, "Type of the variable is not defined.");
            this.variable.setType(Types.metaVar(Kinds.STAR));
        }
        return this.applyPUnit(context);
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        if (context.isInPattern()) {
            this.variable.setType(requiredType);
            return this;
        }
        if (this.variable.getType() == null) {
            context.getErrorLog().log(this.location, "Type of the variable is not defined.");
            this.variable.setType(Types.metaVar(Kinds.STAR));
        }
        return context.subsume(this, requiredType);
    }

    @Override
    public boolean isEffectful() {
        return false;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isPattern(int arity) {
        return arity == 0;
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public boolean equalsExpression(Expression expression) {
        if (expression.getClass() != this.getClass()) {
            return false;
        }
        EVariable other = (EVariable)expression;
        return this.variable == other.variable;
    }
}

