/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class ETypeAnnotation
extends SimplifiableExpression {
    public Expression value;
    Type type;
    TypeAst typeAst;

    public ETypeAnnotation(Expression value, TypeAst typeAst) {
        this.value = value;
        this.typeAst = typeAst;
    }

    public ETypeAnnotation(long loc, Expression value, Type type) {
        super(loc);
        this.value = value;
        this.type = type;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.type);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        return this.value.simplify(context);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.value = this.value.resolve(context);
        this.type = context.toType(this.typeAst);
        return this;
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        this.value = this.value.resolveAsPattern(context);
        this.type = context.toType(this.typeAst);
        return this;
    }

    @Override
    public Expression inferType(TypingContext context) {
        return this.value.checkType(context, this.type);
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.value.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public Expression getValue() {
        return this.value;
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

