/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class ELambdaType
extends Expression {
    public TVar[] parameters;
    public Expression value;

    public ELambdaType(TVar[] parameters, Expression value) {
        super(value.getLocation());
        this.parameters = parameters;
        this.value = value;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.forAll(this.parameters, this.value.getType()));
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        return this.lambdaToVal(context, w);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.value = this.value.simplify(context);
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.value = this.value.resolve(context);
        return this;
    }

    @Override
    public Expression replace(ReplaceContext context) {
        TVar[] newParameters = new TVar[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            TVar var;
            newParameters[i] = var = Types.var(this.parameters[i].getKind());
            context.tvarMap.put((Object)this.parameters[i], (Object)var);
            ++i;
        }
        ELambdaType result = new ELambdaType(newParameters, this.value.replace(context));
        int i2 = 0;
        while (i2 < this.parameters.length) {
            context.tvarMap.remove((Object)this.parameters[i2]);
            ++i2;
        }
        return result;
    }

    @Override
    public IExpression toIExpression(ExpressionInterpretationContext target) {
        return this.value.toIExpression(target);
    }

    @Override
    public Expression inferType(TypingContext context) {
        throw new InternalCompilerError("Should not type check " + this.getClass().getSimpleName() + ".");
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.value.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public int getSyntacticFunctionArity() {
        return this.value.getSyntacticFunctionArity();
    }
}

