/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.constants.DoubleConstant;
import org.simantics.scl.compiler.constants.FloatConstant;
import org.simantics.scl.compiler.constants.IntegerConstant;
import org.simantics.scl.compiler.constants.LongConstant;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class EIntegerLiteral
extends SimplifiableExpression {
    public String value;
    public EVariable constraint;

    public EIntegerLiteral(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    private Expression tryToConvertToPrimitive(Type requiredType) {
        if (requiredType.equals(Types.INTEGER)) {
            return new ELiteral(new IntegerConstant(Integer.parseInt(this.value)));
        }
        if (requiredType.equals(Types.DOUBLE)) {
            return new ELiteral(new DoubleConstant(Double.parseDouble(this.value)));
        }
        if (requiredType.equals(Types.FLOAT)) {
            return new ELiteral(new FloatConstant(Float.parseFloat(this.value)));
        }
        if (requiredType.equals(Types.LONG)) {
            return new ELiteral(new LongConstant(Long.parseLong(this.value)));
        }
        return null;
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        requiredType = Types.canonical(requiredType);
        try {
            Expression primitive = this.tryToConvertToPrimitive(requiredType);
            if (primitive != null) {
                return primitive;
            }
        }
        catch (NumberFormatException numberFormatException) {
            context.getErrorLog().log(this.getLocation(), "Invalid number format.");
        }
        this.setType(requiredType);
        this.constraint = new EVariable(this.location, null);
        this.constraint.setType(Types.pred(Types.RING, requiredType));
        context.addConstraintDemand(this.constraint);
        return this;
    }

    @Override
    protected void updateType() throws MatchException {
        throw new InternalCompilerError();
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        try {
            Expression primitive = this.tryToConvertToPrimitive(Types.canonical(this.getType()));
            if (primitive != null) {
                return primitive;
            }
            return context.apply(context.getConstant(Names.Prelude_fromInteger, this.getType()), this.constraint.simplify(context), context.literal(new IntegerConstant(Integer.parseInt(this.value))));
        }
        catch (NumberFormatException numberFormatException) {
            context.getErrorLog().log(this.getLocation(), "Invalid number format (maybe too long for the expected number type).");
            return this;
        }
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return this;
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        return this;
    }

    @Override
    public Expression replace(ReplaceContext context) {
        EIntegerLiteral copy = new EIntegerLiteral(this.value);
        copy.setType(this.getType().replace(context.tvarMap));
        copy.constraint = (EVariable)this.constraint.replace(context);
        return copy;
    }

    @Override
    public boolean isEffectful() {
        return false;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            if (this.constraint != null) {
                this.constraint.setLocationDeep(loc);
            }
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isPattern(int arity) {
        return arity == 0;
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

