/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class EApplyType
extends Expression {
    public Expression expression;
    Type parameter;

    public EApplyType(Expression expression, Type parameter) {
        this.expression = expression;
        this.parameter = parameter;
    }

    public static Expression create(Expression expression, Type ... parameters) {
        Type[] typeArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            Type parameter = typeArray[n2];
            expression = new EApplyType(expression, parameter);
            ++n2;
        }
        return expression;
    }

    public EApplyType(long loc, Expression expression, Type parameter) {
        super(loc);
        if (parameter == null) {
            throw new NullPointerException();
        }
        this.expression = expression;
        this.parameter = parameter;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Type getParameter() {
        return this.parameter;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.instantiate(this.expression.getType(), this.parameter));
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        IVal val = this.expression.toVal(context, w);
        return val.createSpecialization(this.parameter);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.expression = this.expression.simplify(context);
        if (this.expression instanceof EConstant) {
            ((EConstant)this.expression).addTypeParameters(this.parameter);
            return this.expression;
        }
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.expression = this.expression.resolve(context);
        return this;
    }

    @Override
    public Expression replace(ReplaceContext context) {
        return new EApplyType(this.expression.replace(context), this.parameter.replace(context.tvarMap));
    }

    @Override
    public IExpression toIExpression(ExpressionInterpretationContext target) {
        return this.expression.toIExpression(target);
    }

    @Override
    public Expression inferType(TypingContext context) {
        throw new InternalCompilerError("Should not type check " + this.getClass().getSimpleName() + ".");
    }

    @Override
    public boolean isEffectful() {
        return this.expression.isEffectful();
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.expression.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

