/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr.plan;

import java.util.ArrayList;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanContext;
import org.simantics.scl.compiler.elaboration.chr.plan.PlanOp;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.elaboration.matching2.PatternMatchingCompiler2;
import org.simantics.scl.compiler.internal.elaboration.matching2.Row2;

public class MatchOp
extends PlanOp {
    public Expression scrutinee;
    public Expression pattern;

    public MatchOp(long location, Expression scrutinee, Expression pattern) {
        super(location);
        this.scrutinee = scrutinee;
        this.pattern = pattern;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append("MATCH ").append(this.pattern).append(" = ").append(this.scrutinee);
    }

    @Override
    public void generateCode(CompilationContext context, PlanContext planContext, CodeWriter w) {
        CodeWriter body = w.createBlock();
        CodeWriter end = w.createBlock();
        IVal[] scrutineeVals = new IVal[]{this.scrutinee.toVal(context, w)};
        ArrayList<Row2> rows = new ArrayList<Row2>(1);
        rows.add(new Row2(new Expression[]{this.pattern}, body.getContinuation()));
        PatternMatchingCompiler2.split(this.location, w, context, scrutineeVals, end.getContinuation(), rows);
        planContext.nextOp(body);
        if (body.isUnfinished()) {
            body.jump(this.location, end.getContinuation(), new IVal[0]);
        }
        w.continueAs(end);
    }
}

