/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants.generic;

import gnu.trove.map.hash.THashMap;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.constants.generic.MethodRef;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilderBase;

public class ClassRef {
    public static final TypeDesc[] NO_PARAMS = new TypeDesc[0];
    private THashMap<String, ArrayList<MethodRef>> methods = new THashMap();

    public List<MethodRef> getMethodRefs(String methodName) {
        List refs = (List)this.methods.get((Object)methodName);
        if (refs == null) {
            return Collections.emptyList();
        }
        return refs;
    }

    public ClassRef(ClassLoader classLoader, String className) throws ClassNotFoundException {
        this.analyzeClass(classLoader.loadClass(className), className);
    }

    public ClassRef(Class<?> clazz) {
        this.analyzeClass(clazz, MethodBuilderBase.getClassName(clazz));
    }

    private void analyzeClass(Class<?> clazz, String className) {
        boolean isInterface = clazz.isInterface();
        AccessibleObject[] accessibleObjectArray = clazz.getConstructors();
        int n = accessibleObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = accessibleObjectArray[n2];
            this.addMethodRef("<init>", new MethodRef.ConstructorRef(className, ClassRef.toTypeDescs(constructor.getParameterTypes())));
            ++n2;
        }
        accessibleObjectArray = clazz.getMethods();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            Executable method = accessibleObjectArray[n2];
            if (!((Method)method).isSynthetic()) {
                String methodName = ((Method)method).getName();
                TypeDesc returnType = TypeDesc.forClass(((Method)method).getReturnType());
                TypeDesc[] parameters = ClassRef.toTypeDescs(((Method)method).getParameterTypes());
                int modifiers = ((Method)method).getModifiers();
                if (Modifier.isStatic(modifiers)) {
                    this.addMethodRef(methodName, new MethodRef.StaticMethodRef(className, methodName, returnType, parameters));
                } else {
                    this.addMethodRef(methodName, new MethodRef.ObjectMethodRef(isInterface, className, methodName, returnType, parameters));
                }
            }
            ++n2;
        }
        accessibleObjectArray = clazz.getFields();
        n = accessibleObjectArray.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject field = accessibleObjectArray[n2];
            String fieldName = ((Field)field).getName();
            TypeDesc type = TypeDesc.forClass(((Field)field).getType());
            int modifiers = ((Field)field).getModifiers();
            if (Modifier.isStatic(modifiers)) {
                this.addMethodRef(fieldName, new MethodRef.StaticFieldRef(className, fieldName, type));
                this.addMethodRef("<set>" + fieldName, new MethodRef.SetStaticFieldRef(className, fieldName, type));
            } else {
                this.addMethodRef(fieldName, new MethodRef.FieldRef(className, fieldName, type));
                this.addMethodRef("<set>" + fieldName, new MethodRef.SetFieldRef(className, fieldName, type));
            }
            ++n2;
        }
    }

    private static TypeDesc[] toTypeDescs(Class<?>[] classes) {
        if (classes.length == 0) {
            return NO_PARAMS;
        }
        TypeDesc[] result = new TypeDesc[classes.length];
        int i = 0;
        while (i < result.length) {
            result[i] = TypeDesc.forClass(classes[i]);
            ++i;
        }
        return result;
    }

    private void addMethodRef(String name, MethodRef ref) {
        ArrayList<MethodRef> l = (ArrayList<MethodRef>)this.methods.get((Object)name);
        if (l == null) {
            l = new ArrayList<MethodRef>(2);
            this.methods.put((Object)name, l);
        }
        l.add(ref);
    }
}

