/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.utils.ClassBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.top.SCLCompilerConfiguration;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class JavaStaticMethod
extends FunctionValue {
    String className;
    String methodName;
    TypeDesc returnTypeDesc;
    TypeDesc[] parameterTypeDescs;

    public JavaStaticMethod(String className, String methodName, Type effect, TVar[] typeParameters, Type returnType, Type ... parameterTypes) {
        super(typeParameters, effect, returnType, parameterTypes);
        if (SCLCompilerConfiguration.DEBUG && className.contains("/")) {
            throw new InternalCompilerError();
        }
        ClassBuilder.checkClassName(className);
        this.className = className;
        this.methodName = methodName;
    }

    public JavaStaticMethod(String className, String methodName, Type effect, Type returnType, Type ... parameterTypes) {
        super(Types.freeVarsArray(Types.functionE(parameterTypes, effect, returnType)), effect, returnType, parameterTypes);
        if (SCLCompilerConfiguration.DEBUG && className.contains("/")) {
            throw new InternalCompilerError();
        }
        ClassBuilder.checkClassName(className);
        this.className = className;
        this.methodName = methodName;
    }

    public JavaStaticMethod(String className, String methodName, Type effect, TypeDesc returnTypeDesc, TypeDesc[] parameterTypeDescs, Type returnType, Type ... parameterTypes) {
        super(Types.freeVarsArray(Types.functionE(parameterTypes, effect, returnType)), effect, returnType, parameterTypes);
        if (SCLCompilerConfiguration.DEBUG) {
            if (className == null) {
                throw new NullPointerException();
            }
            if (methodName == null) {
                throw new NullPointerException();
            }
            if (parameterTypeDescs != null) {
                TypeDesc[] typeDescArray = parameterTypeDescs;
                int n = parameterTypeDescs.length;
                int n2 = 0;
                while (n2 < n) {
                    TypeDesc td = typeDescArray[n2];
                    if (td.equals(TypeDesc.VOID)) {
                        throw new InternalCompilerError();
                    }
                    ++n2;
                }
            }
        }
        if (returnTypeDesc == null != (parameterTypeDescs == null)) {
            throw new IllegalArgumentException("Either specify both returnTypeDesc and parameterTypeDescs or neither");
        }
        ClassBuilder.checkClassName(className);
        this.className = className;
        this.methodName = methodName;
        this.returnTypeDesc = returnTypeDesc;
        this.parameterTypeDescs = parameterTypeDescs;
    }

    public JavaStaticMethod(String className, String methodName, TypeDesc returnTypeDesc, TypeDesc[] parameterTypeDescs, Type returnType, Type ... parameterTypes) {
        this(className, methodName, (Type)Types.NO_EFFECTS, returnTypeDesc, parameterTypeDescs, returnType, parameterTypes);
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        if (this.returnTypeDesc == null || this.parameterTypeDescs == null) {
            JavaTypeTranslator tt = mb.getJavaTypeTranslator();
            this.returnTypeDesc = tt.toTypeDesc(this.returnType);
            this.parameterTypeDescs = JavaTypeTranslator.filterVoid(tt.toTypeDescs(this.parameterTypes));
        }
        mb.push(parameters, this.getParameterTypes());
        mb.invokeStatic(this.className, this.methodName, this.returnTypeDesc, this.parameterTypeDescs);
        return this.getReturnType();
    }

    public String toString() {
        return this.className + "#" + this.methodName;
    }
}

