/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.constants;

import java.util.Arrays;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class JavaConstructor
extends FunctionValue {
    String className;
    boolean hasStaticInstance = false;
    TypeDesc[] parameterTypeDescs;

    public JavaConstructor(String className, Type effect, Type returnType, Type ... parameterTypes) {
        super(Types.freeVarsArray(Types.functionE(parameterTypes, effect, returnType)), effect, returnType, parameterTypes);
        this.className = className;
    }

    public JavaConstructor(String className, Type effect, TypeDesc[] parameterTypeDescs, Type returnType, Type ... parameterTypes) {
        super(Types.freeVarsArray(Types.functionE(parameterTypes, effect, returnType)), effect, returnType, parameterTypes);
        this.className = className;
        this.parameterTypeDescs = parameterTypeDescs;
    }

    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        if (this.parameterTypeDescs == null) {
            JavaTypeTranslator tt = mb.getJavaTypeTranslator();
            this.parameterTypeDescs = tt.toTypeDescs(this.parameterTypes);
        }
        TypeDesc typeDesc = TypeDesc.forClass(this.className);
        if (this.hasStaticInstance) {
            mb.loadStaticField(typeDesc, "INSTANCE", typeDesc);
        } else {
            mb.newObject(typeDesc);
            mb.dup();
            mb.push(parameters, this.parameterTypes);
            mb.invokeConstructor(this.className, this.parameterTypeDescs);
        }
        return this.getReturnType();
    }

    public String toString() {
        return this.className + ".<init>";
    }

    public void setHasStaticInstance(boolean hasStaticInstance) {
        if (this.parameterTypes.length > 0) {
            throw new InternalCompilerError();
        }
        this.hasStaticInstance = hasStaticInstance;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.hasStaticInstance ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.parameterTypeDescs);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaConstructor other = (JavaConstructor)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.hasStaticInstance != other.hasStaticInstance) {
            return false;
        }
        return Arrays.equals(this.parameterTypeDescs, other.parameterTypeDescs);
    }
}

