/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.completions.parsing;

import java.util.ArrayList;
import java.util.List;
import org.simantics.scl.compiler.completions.parsing.ModuleSegment;

public class RobustModuleSplitter {
    private static final int NORMAL_START_OF_LINE = 0;
    private static final int NORMAL = 1;
    private static final int NORMAL_1QUOTE = 2;
    private static final int NORMAL_2QUOTE = 3;
    private static final int SHORT_STRING = 4;
    private static final int SHORT_STRING_BACKSLASH = 5;
    private static final int LONG_STRING = 6;
    private static final int LONG_STRING_1QUOTE = 7;
    private static final int LONG_STRING_2QUOTE = 8;
    private static final int CHAR_LITERAL = 9;
    private static final int CHAR_LITERAL_BACKSLASH = 10;
    private static final int NORMAL_1SLASH = 11;
    private static final int C_COMMENT = 12;
    private static final int C_COMMENT_STAR = 13;
    private static final int CPP_COMMENT = 14;
    private final String sourceText;
    private ArrayList<ModuleSegment> segments = new ArrayList();

    private RobustModuleSplitter(String sourceText) {
        this.sourceText = sourceText;
    }

    private static boolean isLineEnd(char c) {
        return c == '\n' || c == '\u0000';
    }

    private void split() {
        int state = 1;
        int begin = 0;
        int pos = 0;
        int curEntityBegin = 0;
        int parenthesesBalance = 0;
        boolean hasErrors = false;
        int length = this.sourceText.length();
        block17: while (true) {
            char c;
            char c2 = c = pos == length ? (char)'\u0000' : this.sourceText.charAt(pos++);
            if (c == '\r') {
                c = '\n';
            }
            switch (state) {
                case 0: {
                    if (c == '\n') continue block17;
                    if (c != ' ') {
                        int end = c == '\u0000' ? pos : pos - 1;
                        this.segments.add(new ModuleSegment(begin, end, parenthesesBalance, hasErrors));
                        parenthesesBalance = 0;
                        hasErrors = false;
                        begin = end;
                    }
                    state = 1;
                }
                case 1: {
                    if (c == '\"') {
                        state = 2;
                        continue block17;
                    }
                    if (c == '/') {
                        state = 11;
                        continue block17;
                    }
                    if (c == '\'') {
                        state = 9;
                        continue block17;
                    }
                    if (c == '(' || c == '[' || c == '{') {
                        ++parenthesesBalance;
                        continue block17;
                    }
                    if (c == ')' || c == ']' || c == '}') {
                        --parenthesesBalance;
                        continue block17;
                    }
                    if (c == '\n') {
                        state = 0;
                        continue block17;
                    }
                    if (c != '\u0000') continue block17;
                    break block17;
                }
                case 2: {
                    if (c == '\"') {
                        state = 3;
                        continue block17;
                    }
                    if (c == '\\') {
                        state = 5;
                        continue block17;
                    }
                    if (c == '\u0000') break block17;
                    state = 4;
                    continue block17;
                }
                case 3: {
                    if (c == '\"') {
                        state = 6;
                        continue block17;
                    }
                    state = 1;
                    if (c == '\u0000') continue block17;
                    --pos;
                    continue block17;
                }
                case 4: {
                    if (c == '\\') {
                        state = 5;
                        continue block17;
                    }
                    if (c != '\"' && !RobustModuleSplitter.isLineEnd(c)) continue block17;
                    state = c == '\n' ? 0 : 1;
                    hasErrors = c != '\"';
                    continue block17;
                }
                case 5: {
                    if (RobustModuleSplitter.isLineEnd(c)) {
                        state = 0;
                        continue block17;
                    }
                    state = 4;
                    continue block17;
                }
                case 6: {
                    if (c == '\"') {
                        state = 7;
                        continue block17;
                    }
                    if (c != '\u0000') continue block17;
                    curEntityBegin = pos;
                    state = 1;
                    hasErrors = true;
                    continue block17;
                }
                case 7: {
                    if (c == '\"') {
                        state = 8;
                        continue block17;
                    }
                    state = 6;
                    continue block17;
                }
                case 8: {
                    if (c == '\"') {
                        state = 1;
                        continue block17;
                    }
                    state = 6;
                    continue block17;
                }
                case 9: {
                    if (c == '\'' || RobustModuleSplitter.isLineEnd(c)) {
                        state = c == '\n' ? 0 : 1;
                        hasErrors = c != '\'';
                        continue block17;
                    }
                    if (c != 92) continue block17;
                    state = 10;
                    continue block17;
                }
                case 10: {
                    if (RobustModuleSplitter.isLineEnd(c)) {
                        state = 0;
                        hasErrors = true;
                        continue block17;
                    }
                    state = 9;
                    continue block17;
                }
                case 11: {
                    if (c == '/') {
                        state = 14;
                        continue block17;
                    }
                    if (c == '*') {
                        state = 12;
                        curEntityBegin = pos;
                        continue block17;
                    }
                    state = 1;
                    if (c == '\u0000') continue block17;
                    --pos;
                    continue block17;
                }
                case 12: {
                    if (c == '*') {
                        state = 13;
                        continue block17;
                    }
                    if (c != '\u0000') continue block17;
                    pos = curEntityBegin;
                    state = 1;
                    hasErrors = true;
                    continue block17;
                }
                case 13: {
                    if (c == '/') {
                        state = 1;
                        continue block17;
                    }
                    state = 12;
                    continue block17;
                }
                case 14: {
                    if (!RobustModuleSplitter.isLineEnd(c)) continue block17;
                    state = 0;
                }
                default: {
                    continue block17;
                }
            }
            break;
        }
        if (begin != length) {
            this.segments.add(new ModuleSegment(begin, length, parenthesesBalance, hasErrors));
        }
    }

    private void combineByParenthesesBalance() {
        ArrayList<ModuleSegment> segmentStack = null;
        for (ModuleSegment segment : this.segments) {
            if (segment.parenthesesBalance > 0) {
                if (segmentStack == null) {
                    segmentStack = new ArrayList<ModuleSegment>();
                }
                int i = 0;
                while (i < segment.parenthesesBalance) {
                    segmentStack.add(segment);
                    ++i;
                }
                continue;
            }
            if (segment.parenthesesBalance >= 0) continue;
            if (segmentStack == null) {
                segment.parenthesesBalance = 0;
                segment.hasErrors = true;
                continue;
            }
            int r = -segment.parenthesesBalance;
            while (r > 0 && !segmentStack.isEmpty()) {
                segmentStack.remove(segmentStack.size() - 1);
                --r;
            }
            if (r <= 0) continue;
            segment.parenthesesBalance += r;
            segment.hasErrors = true;
        }
        if (segmentStack == null) {
            return;
        }
        for (ModuleSegment segment : segmentStack) {
            --segment.parenthesesBalance;
            segment.hasErrors = true;
        }
        ArrayList<ModuleSegment> oldSegments = this.segments;
        this.segments = new ArrayList(oldSegments.size());
        int currentBalance = 0;
        int begin = 0;
        boolean hasErrors = false;
        for (ModuleSegment segment : oldSegments) {
            if (currentBalance == 0) {
                if (segment.parenthesesBalance == 0) {
                    this.segments.add(segment);
                    continue;
                }
                begin = segment.begin;
                currentBalance = segment.parenthesesBalance;
                hasErrors = segment.hasErrors;
                continue;
            }
            hasErrors |= segment.hasErrors;
            if ((currentBalance += segment.parenthesesBalance) != 0) continue;
            this.segments.add(new ModuleSegment(begin, segment.end, 0, hasErrors));
        }
    }

    public static List<ModuleSegment> split(String sourceText) {
        RobustModuleSplitter splitter = new RobustModuleSplitter(sourceText);
        splitter.split();
        splitter.combineByParenthesesBalance();
        return splitter.segments;
    }
}

