/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.compilation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.compilation.NamespaceOfModule;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Namespace;
import org.simantics.scl.compiler.internal.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.types.TCon;

public class EnvironmentOfModule
implements Environment {
    Environment base;
    Module module;
    Namespace localNamespace;

    public EnvironmentOfModule(Environment base, Module module) {
        this.base = base;
        this.module = module;
        this.localNamespace = new NamespaceOfModule(base.getLocalNamespace(), module);
    }

    @Override
    public Namespace getLocalNamespace() {
        return this.localNamespace;
    }

    @Override
    public SCLValue getValue(Name name) {
        if (name.module.equals(this.module.getName())) {
            return this.module.getValue(name.name);
        }
        return this.base.getValue(name);
    }

    @Override
    public List<Constant> getFieldAccessors(String name) {
        List<Constant> r1 = this.base.getFieldAccessors(name);
        List<Constant> r2 = this.module.getFieldAccessors(name);
        if (r1 == null) {
            return r2;
        }
        if (r2 == null) {
            return r1;
        }
        ArrayList<Constant> result = new ArrayList<Constant>(r1.size() + r2.size());
        result.addAll(r1);
        result.addAll(r2);
        return result;
    }

    @Override
    public SCLRelation getRelation(Name name) {
        if (name.module.equals(this.module.getName())) {
            return this.module.getRelation(name.name);
        }
        return this.base.getRelation(name);
    }

    @Override
    public SCLEntityType getEntityType(Name name) {
        if (name.module.equals(this.module.getName())) {
            return this.module.getEntityType(name.name);
        }
        return this.base.getEntityType(name);
    }

    @Override
    public TypeDescriptor getTypeDescriptor(TCon type) {
        if (type.module.equals(this.module.getName())) {
            return this.module.getTypeDescriptor(type.name);
        }
        return this.base.getTypeDescriptor(type);
    }

    @Override
    public EffectConstructor getEffectConstructor(TCon type) {
        if (type.module.equals(this.module.getName())) {
            return this.module.getEffectConstructor(type.name);
        }
        return this.base.getEffectConstructor(type);
    }

    @Override
    public TypeClass getTypeClass(TCon type) {
        if (type.module.equals(this.module.getName())) {
            return this.module.getTypeClass(type.name);
        }
        return this.base.getTypeClass(type);
    }

    @Override
    public Collection<TypeClassInstance> getInstances(TCon typeClass) {
        Collection<TypeClassInstance> inst1 = this.module.getInstances(typeClass);
        Collection<TypeClassInstance> inst2 = this.base.getInstances(typeClass);
        if (inst1.isEmpty()) {
            return inst2;
        }
        if (inst2.isEmpty()) {
            return inst1;
        }
        ArrayList<TypeClassInstance> union = new ArrayList<TypeClassInstance>(inst1.size() + inst2.size());
        union.addAll(inst1);
        union.addAll(inst2);
        return union;
    }

    @Override
    public void collectRules(Collection<TransformationRule> rules) {
        this.base.collectRules(rules);
        rules.addAll(this.module.getRules());
    }
}

