/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.compilation;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.internal.parsing.declarations.DDocumentationAst;
import org.simantics.scl.compiler.module.ConcreteModule;
import org.simantics.scl.compiler.types.TCon;

public class DocumentationGeneration {
    THashMap<String, DDocumentationAst> valueDocumentation;
    THashMap<String, DDocumentationAst> typeDocumentation;
    THashMap<String, DDocumentationAst> classDocumentation;
    ConcreteModule module;
    THashSet<String> mentionedInDocumentation = new THashSet();
    THashMap<TCon, ArrayList<TypeClassInstance>> dataToInstance = new THashMap();

    public DocumentationGeneration(THashMap<String, DDocumentationAst> valueDocumentation, THashMap<String, DDocumentationAst> typeDocumentation, THashMap<String, DDocumentationAst> classDocumentation, ConcreteModule module) {
        this.valueDocumentation = valueDocumentation;
        this.typeDocumentation = typeDocumentation;
        this.classDocumentation = classDocumentation;
        this.module = module;
    }

    public void generateDocumentation() {
        DDocumentationAst doc;
        for (String name : this.classDocumentation.keySet()) {
            TypeClass typeClass = this.module.getTypeClass(name);
            doc = (DDocumentationAst)this.classDocumentation.get((Object)name);
            if (typeClass == null || doc == null) continue;
            typeClass.setDocumentation(doc.documentation);
        }
        for (String name : this.valueDocumentation.keySet()) {
            SCLValue value = this.module.getValue(name);
            doc = (DDocumentationAst)this.valueDocumentation.get((Object)name);
            if (value == null || doc == null) continue;
            value.setDocumentation(doc.documentation);
        }
        for (String name : this.typeDocumentation.keySet()) {
            TypeDescriptor typeConstructor = this.module.getTypeDescriptor(name);
            doc = (DDocumentationAst)this.typeDocumentation.get((Object)name);
            if (typeConstructor == null || doc == null) continue;
            typeConstructor.setDocumentation(doc.documentation);
        }
    }
}

