/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.commands;

import java.io.BufferedReader;
import java.io.IOException;
import org.junit.Assert;
import org.simantics.scl.compiler.commands.CommandSession;
import org.simantics.scl.runtime.reporting.AbstractSCLReportingHandler;
import org.simantics.scl.runtime.reporting.SCLReportingHandler;

public class TestScriptExecutor {
    private final CommandSession session;
    private final BufferedReader reader;
    private final SCLReportingHandler handler;
    private boolean ignorePrints;

    public TestScriptExecutor(CommandSession session, BufferedReader reader, SCLReportingHandler handler) {
        this(session, reader, handler, false);
    }

    public TestScriptExecutor(CommandSession session, BufferedReader reader, SCLReportingHandler handler, boolean ignorePrints) {
        this.session = session;
        this.reader = reader;
        this.handler = handler == null ? SCLReportingHandler.DEFAULT : handler;
        this.ignorePrints = ignorePrints;
    }

    public void execute() throws IOException {
        StringBuilder command = new StringBuilder();
        StringBuilder response = new StringBuilder();
        block0: while (true) {
            String line;
            if ((line = this.reader.readLine()) == null) {
                this.execute(command.toString(), response.toString());
                return;
            }
            if (line.startsWith("> ")) {
                command.append(line.substring(2)).append('\n');
                continue;
            }
            response.append(line).append('\n');
            while (true) {
                if ((line = this.reader.readLine()) == null) {
                    this.execute(command.toString(), response.toString());
                    return;
                }
                if (line.startsWith("> ")) {
                    this.execute(command.toString(), response.toString());
                    command = new StringBuilder();
                    response = new StringBuilder();
                    command.append(line.substring(2)).append('\n');
                    continue block0;
                }
                response.append(line).append('\n');
            }
            break;
        }
    }

    private void execute(String command, String expectedResponse) {
        final StringBuilder actualResponse = new StringBuilder();
        final StringBuilder errors = new StringBuilder();
        this.session.execute(command, (SCLReportingHandler)new AbstractSCLReportingHandler(){

            public void print(String text) {
                TestScriptExecutor.this.handler.print(text);
                if (!TestScriptExecutor.this.ignorePrints) {
                    actualResponse.append(text).append('\n');
                }
            }

            public void printError(String error) {
                TestScriptExecutor.this.handler.printError(error);
                errors.append(error).append('\n');
            }

            public void printCommand(String command) {
                TestScriptExecutor.this.handler.printCommand(command);
            }
        });
        if (errors.length() > 0) {
            Assert.fail((String)("Command '" + command.trim() + "' produced error " + errors.toString().trim() + "."));
        }
        String expected = expectedResponse.trim().replaceAll("\\r", "");
        String actual = actualResponse.toString().trim().replaceAll("\\r", "");
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

