package org.simantics.scl.compiler.types.exceptions;

import java.util.Collection;
import java.util.Collections;

public class SCLTypeParseException extends Exception {

    private static final long serialVersionUID = -8245068555543510452L;
    
    Collection<Problem> problems;

    public SCLTypeParseException(Collection<Problem> problems) {
        super(toString(problems));
        this.problems = problems;
    }
    
    public SCLTypeParseException(Problem problem) {
        this(Collections.singleton(problem));
    }

    public Collection<Problem> getProblems() {
        return problems;
    }
    
    private static String toString(Collection<Problem> problems) {
        StringBuilder b = new StringBuilder();
        for(Problem problem : problems) {
            problem.toString(b);
            b.append('\n');
        }
        return b.toString();
    }
}
