package org.simantics.scl.compiler.top;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;

import gnu.trove.impl.Constants;
import gnu.trove.map.hash.TObjectIntHashMap;


public class ExpressionInterpretationContext {

    public final RuntimeEnvironment runtimeEnvironment;
    public final TransientClassBuilder localClassBuilder;
    private int curVariableId = 0;
    private int maxVariableId = 0;
    private final TObjectIntHashMap<Variable> variableIds =
            new TObjectIntHashMap<Variable>(
                    Constants.DEFAULT_CAPACITY,
                    Constants.DEFAULT_LOAD_FACTOR,
                    -1);
    
    public ExpressionInterpretationContext(
            RuntimeEnvironment runtimeEnvironment,
            TransientClassBuilder localClassBuilder) {
        this.runtimeEnvironment = runtimeEnvironment;
        this.localClassBuilder = localClassBuilder;
    }

    public int push(Variable var) {
        int id = curVariableId++;
        variableIds.put(var, id);
        maxVariableId = Math.max(maxVariableId, curVariableId);
        return id;
    }
    
    public void pop(Variable var) {
        int id = variableIds.remove(var);
        --curVariableId;
        if(id != curVariableId)
            throw new IllegalStateException("Variable pushs and pops don't match.");
    }
    
    public int getVariableId(Variable var) {
        int id = variableIds.get(var);
        if(id < 0)
            throw new InternalCompilerError("Encontered bug while interpreting exception: variable " + var + " was not bounded.");
        return id;
    }

    public ExpressionInterpretationContext createNewContext() {
        return new ExpressionInterpretationContext(runtimeEnvironment, localClassBuilder);
    }
    
    public int getMaxVariableId() {
        return maxVariableId;
    }
}
