package org.simantics.scl.compiler.parser.generator.table;

import java.util.Arrays;
import java.util.Collection;

import org.simantics.scl.compiler.parser.generator.grammar.AnaGrammar;

public class ItemSet {
    public final Item[] items;
    int hash;

    public ItemSet(Item[] items) {
        this.items = items;
        Arrays.sort(items);
    }
    
    public ItemSet(Collection<Item> items) {
        this(items.toArray(new Item[items.size()]));
    }
    
    private static final int PROD = 31*31;
    
    @Override
    public int hashCode() {
        if(hash == 0) {
            int h = 1;
            for(Item item : items)
                h = PROD*h + item.hashCode();
            hash = h;
        }
        return hash;
    }
    
    @Override
    public boolean equals(Object obj) {
        if(this == obj)
            return true;
        if(obj == null || obj.getClass() != getClass())
            return false;
        ItemSet other = (ItemSet)obj;
        if(other.items.length != items.length)
            return false;
        for(int i=0;i<items.length;++i)
            if(!items[i].equals(other.items[i]))
                return false;
        return true;
    }
    
    public String toString(AnaGrammar grammar) {
        StringBuilder b = new StringBuilder();
            boolean first = true;
        for(Item item : items) {
            if(first)
                first = false;
            else
                b.append('\n');
            b.append("    ").append(item.toString(grammar));
        }
        return b.toString();
    }
}
