package org.simantics.scl.compiler.parser.generator.compression;

import org.simantics.scl.compiler.parser.generator.table.ParseTableBuilder;

public class ErrorTable {
    public static int[] createErrorTable(int[][] table) {
        int columns = table[0].length;
        int[] result = new int[(table.length*columns+31)/32];
        int p=0;
        for(int[] row : table)
            for(int v : row) {
                if(v == ParseTableBuilder.ERROR_ACTION)
                    result[p/32] |= 1 << (p%32); 
                ++p;
            }
        return result;
    }
}
