package org.simantics.scl.compiler.parser.generator.compression;

import java.io.DataOutputStream;
import java.io.IOException;


public class CompressedTable {
    public final int[] rowIndex;
    public final int[] columnIndex;
    public final int[] table;
    
    public CompressedTable(int[] rowIndex, int[] columnIndex, int[] table) {
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
        this.table = table;
    }
    
    public void writeTo(DataOutputStream output) throws IOException {
        for(int v : rowIndex)
            output.writeInt(v);
        for(int v : columnIndex)
            output.writeInt(v);
        for(int v : table)
            output.writeShort(v);
    }
}
