package org.simantics.scl.compiler.parser.generator.compression;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class CompressedParseTable {
    public final CompressedTable actionTable;
    public final int[] errorTable;
    public final CompressedTable gotoTable;
    public final int[] productionInfo;
    public final int[] initialStates;
    public final String[] stateDescriptions;
    
    public CompressedParseTable(CompressedTable actionTable,
            int[] errorTable,
            CompressedTable gotoTable, int[] productionInfo,
            int[] initialStates,
            String[] stateDescriptions) {
        this.actionTable = actionTable;
        this.errorTable = errorTable;
        this.gotoTable = gotoTable;
        this.productionInfo = productionInfo;
        this.initialStates = initialStates;
        this.stateDescriptions = stateDescriptions;
    }
    
    public void writeTo(File file) throws IOException {
        FileOutputStream stream = new FileOutputStream(file);
        DataOutputStream output = new DataOutputStream(stream);
        actionTable.writeTo(output);
        for(int val : errorTable)
            output.writeInt(val);
        gotoTable.writeTo(output);
        for(int val : productionInfo)
            output.writeInt(val);
        output.close();
    }
}
