package org.simantics.scl.compiler.module.options;

import java.util.Objects;

public class ModuleCompilationOptions {
	
    public static final ModuleCompilationOptions STANDARD_OPTIONS = new ModuleCompilationOptions(false);
    public static final ModuleCompilationOptions SILENT = new ModuleCompilationOptions(false);
    private static final StoredModuleSupport DEFAULT_CLASS_LOADER_PROVIDER = new DefaultStoredModuleSupport();

    static {
        SILENT.silent = true;
    }
    
    public static enum StoreOption {
    	NONE,READ,WRITE;
    	public static StoreOption parse(String value) {
    		if("write".equals(value))
    			return WRITE;
    		else if("read".equals(value))
    			return READ;
    		return NONE;
    	}
    }
    
    public boolean computeCoverage;
    public StoreOption store;
    public boolean silent = false;
    public boolean collectDebugInfo = false;
    public StoredModuleSupport classLoaderProvider;

    public ModuleCompilationOptions(boolean computeCoverage) {
    	this(computeCoverage, StoreOption.NONE);
    }

    public ModuleCompilationOptions(boolean computeCoverage, StoreOption store) {
    	this(computeCoverage, store, false, false, DEFAULT_CLASS_LOADER_PROVIDER);
    }
    
    private ModuleCompilationOptions(boolean computeCoverage, StoreOption store, boolean silent, boolean collectDebugInfo, StoredModuleSupport classLoaderProvider) {
        this.computeCoverage = computeCoverage;
        this.store = store;
        this.silent = silent;
        this.collectDebugInfo = collectDebugInfo;
        this.classLoaderProvider = classLoaderProvider;
    }
    
    public ModuleCompilationOptions withStore(StoreOption value) {
    	if(Objects.equals(store, value))
    		return this;
    	else
    		return new ModuleCompilationOptions(computeCoverage, value, silent, collectDebugInfo, classLoaderProvider);
    }
    
}
