package org.simantics.scl.compiler.module.coverage;

public abstract class AbstractCoverage implements Coverage {

    private String identifier;

    private final int totalCodeSize;
    private final int coveredCodeSize;
    private final double coverage;

    public AbstractCoverage(String identifier, int totalCodeSize, int coveredCodeSize) {
        this.identifier = identifier;
        this.coverage = CoverageUtils.safeDiv(coveredCodeSize, totalCodeSize);
        this.totalCodeSize = totalCodeSize;
        this.coveredCodeSize = coveredCodeSize;
    }

    @Override
    public String getIdentifier() {
        return identifier;
    }

    @Override
    public double getCoverage() {
        return coverage;
    }

    @Override
    public int getTotalCodeSize() {
        return totalCodeSize;
    }

    @Override
    public int getCoveredCodeSize() {
        return coveredCodeSize;
    }

    @Override
    public int getMissedCodeSize() {
        return totalCodeSize - coveredCodeSize;
    }

    String toPercent(double v) {
        return String.valueOf(v*100.0) + "%";
    }

}
