package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.html.HtmlGenerationContext;
import org.simantics.scl.compiler.markdown.internal.HtmlEscape;

public class TextNode extends Node {
    public TextNode(StringBuilder text) {
        this.stringContent = text;
    }
    @Override
    public void toHtml(HtmlGenerationContext context, StringBuilder b) {
        b.append(HtmlEscape.escape(stringContent));
    }
    @Override
    public void toPlainText(StringBuilder b) {
        b.append(HtmlEscape.escape(stringContent));
    }
}
