package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.html.HtmlGenerationContext;

public class HeaderNode extends Node {
    public int level;
    public boolean setext;

    public HeaderNode(int level, boolean setext) {
        this.level = level;
        this.setext = setext;
    }
    
    @Override
    public boolean acceptLines() {
        return !setext;
    }
    
    @Override
    public void toHtml(HtmlGenerationContext context, StringBuilder b) {
        b.append("<h").append(level);
        if(context.generateAnchors) {
            b.append(" id=\"");
            toPlainText(b);
            b.append("\">");
        }
        else
            b.append('>');
        super.toHtml(context, b);
        b.append("</h").append(level).append(">\n");
    }
}
