package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.html.HtmlGenerationContext;
import org.simantics.scl.compiler.markdown.internal.ExtensionNodeHandler;

public class ExtensionBlockNode extends Node {
    String extension;
    String content;
    
    public ExtensionBlockNode(String extension, String content) {
        this.extension = extension;
        this.content = content;
    }
    
    @Override
    public void processExtensionNodes(ExtensionNodeHandler handler) {
        DocumentNode replacingNodes = handler.expandBlock(extension, content);
        if(replacingNodes != null) {
            if(replacingNodes.firstChild == null)
                remove();
            else {
                for(Node child = replacingNodes.firstChild; child != null; child = child.next)
                    child.parent = parent;
                if(prev == null)
                    parent.firstChild = replacingNodes.firstChild;
                else {
                    replacingNodes.firstChild.prev = prev;
                    prev.next = replacingNodes.firstChild;
                }
                if(next == null)
                    parent.lastChild = replacingNodes.lastChild;
                else {
                    replacingNodes.lastChild.next = next;
                    next.prev = replacingNodes.lastChild;
                }
            }
        }
    }
    
    @Override
    public void toHtml(HtmlGenerationContext context, StringBuilder b) {
        b.append("::").append(extension).append('[').append(content).append(']');
    }
}
