package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.html.HtmlGenerationContext;

public class EmphNode extends Node {
    boolean strong;
    
    public EmphNode(boolean strong) {
        this.strong = strong;
    }

    @Override
    public void toHtml(HtmlGenerationContext context, StringBuilder b) {
        if(strong)
            b.append("<strong>");
        else
            b.append("<em>");
        super.toHtml(context, b);
        if(strong)
            b.append("</strong>");
        else
            b.append("</em>");
    }
}
