package org.simantics.scl.compiler.internal.types.ast;

import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.SCLTypeParseException;

public class TPredAst extends TypeAst {

    public final TypeAst constraint;
    public final TypeAst type;
    
    public TPredAst(TypeAst constraint, TypeAst type) {
        this.constraint = constraint;
        this.type = type;
    }

    @Override
    public void toString(StringBuilder b) {
        constraint.toString(b);
        b.append(" => ");
        type.toString(b);
    }

    @Override
    public Type toType(TypeElaborationContext context) throws SCLTypeParseException {
        return Types.constrained(
                constraint.toTFuncApply(context),
                type.toType(context));
    }

    @Override
    public int getPrecedence() {
        return 2;
    }

}
