package org.simantics.scl.compiler.internal.types.ast;

import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.SCLTypeParseException;



public class TForAllAst extends TypeAst {
    public final String[] vars;
    public final TypeAst type;
    
    public TForAllAst(String[] vars, TypeAst type) {
        this.vars = vars;
        this.type = type;
    }
    
    @Override
    public void toString(StringBuilder b) {
        b.append("forall");
        for(String var : vars) {
            b.append(' ');
            b.append(var);
        }
        b.append(". ");
        type.toString(b);
    }

    @Override
    public Type toType(TypeElaborationContext context) throws SCLTypeParseException {
        TVar[] oldVars = new TVar[vars.length];
        for(int i=0;i<vars.length;++i)
            oldVars[i] = context.push(vars[i]);
        Type result = type.toType(context);
        for(int i=vars.length-1;i>=0;--i)
            result = Types.forAll(context.pop(vars[i], oldVars[i]), result);
        return result;
    }
    
    @Override
    public int getPrecedence() {
        return 2;
    }
}
