package org.simantics.scl.compiler.internal.types;

import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.compiler.types.util.ITypeEnvironment;

import gnu.trove.map.hash.THashMap;

public class TypeElaborationContext {

    THashMap<String, TVar> vars;
    THashMap<String, TMetaVar> existentials;
    ITypeEnvironment environment;
        
    public TypeElaborationContext(
            THashMap<String, TVar> vars,
            ITypeEnvironment environment) {
        this.vars = vars;
        this.environment = environment;
    }
    
    public TypeElaborationContext(ITypeEnvironment environment) {
        this(new THashMap<String, TVar>(), environment);
    }

    public TMetaVar resolveExistential(String varName) {
        if(existentials == null)
            existentials = new THashMap<String, TMetaVar>();
        TMetaVar var = existentials.get(varName);
        if(var == null) {
            var = Types.metaVar(Kinds.metaVar());
            existentials.put(varName, var);
        }
        return var;
    }

    public TVar resolveTypeVariable(String varName) {
        TVar var = vars.get(varName);
        if(var == null) {
            var = Types.var(Kinds.metaVar());
            vars.put(varName, var);
        }
        return var;
    }
    
    public TVar push(String varName) {
        return vars.put(varName, Types.var(Kinds.metaVar())); 
    }

    public TVar pop(String varName, TVar oldVar) {
        if(oldVar == null)
            return vars.remove(varName);
        else
            return vars.put(varName, oldVar);
    }
    
    public Type resolveTypeConstructor(String name) {
        return environment.resolve(null, name);
    }

    public Type resolveTypeConstructor(String namespace, String name) {
        return environment.resolve(namespace, name);
    }

}
