package org.simantics.scl.compiler.internal.parsing.types;

import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

public class TPredAst extends TypeAst {

    public final TypeAst constraint;
    public final TypeAst type;
    
    public TPredAst(TypeAst constraint, TypeAst type) {
        this.constraint = constraint;
        this.type = type;
    }

    @Override
    public void toString(StringBuilder b) {
        constraint.toString(b);
        b.append(" => ");
        type.toString(b);
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        context.unify(location, Kinds.STAR, expectedKind);
        return Types.constrained(
                constraint.toTFuncApply(context),
                type.toType(context, Kinds.STAR));
    }
    
    @Override
    public Type toType(TypeElaborationContext context) {
        return Types.constrained(
                constraint.toTFuncApply(context),
                type.toType(context));
    }

    @Override
    public int getPrecedence() {
        return 2;
    }

    @Override
    public void collectReferences(TObjectIntHashMap<String> typeNameMap,
            TIntHashSet set) {
        constraint.collectReferences(typeNameMap, set);
        type.collectReferences(typeNameMap, set);
    }

}
