package org.simantics.scl.compiler.internal.parsing.types;

import java.util.ArrayList;

import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;



public class TEffectAst extends TypeAst {
    public final TypeAst[] effects;
    public final TypeAst type;
    
    public TEffectAst(TypeAst effect, TypeAst type) {
        this.effects = new TypeAst[] {effect};
        this.type = type;
    }
    
    public TEffectAst(TypeAst[] effects, TypeAst type) {
        this.effects = effects;
        this.type = type;
    }
    
    public TEffectAst(ArrayList<TypeAst> effects, TypeAst type) {
        this(effects.toArray(new TypeAst[effects.size()]), type);
    }

    @Override
    public void toString(StringBuilder b) {
        b.append('<');
        boolean first = true;
        for(TypeAst effect : effects) {
            if(first)
                first = false;
            else
                b.append(",");
            effect.toString(b);
        }
        b.append("> ");
        b.append(type);
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        context.unify(location, Kinds.STAR, expectedKind);
        return Types.functionE(
                Types.PUNIT,
                TFunctionAst.toEffect(context, effects),
                type.toType(context, Kinds.STAR));
    }
    
    @Override
    public Type toType(TypeElaborationContext context) {
        return Types.functionE(
                Types.PUNIT,
                TFunctionAst.toEffect(context, effects),
                type.toType(context));
    }

    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public void collectReferences(TObjectIntHashMap<String> typeNameMap,
            TIntHashSet set) {
        for(TypeAst effect : effects)
            effect.collectReferences(typeNameMap, set);
        type.collectReferences(typeNameMap, set);
    }
}
