package org.simantics.scl.compiler.internal.parsing.documentation;

public class Preformatted extends DocumentationElement {

    String[] lines;
    
    public Preformatted(String content) {
        lines = content.split("\n");
        int indentation = Integer.MAX_VALUE;
        for(int i=0;i<lines.length;++i) {
            String line = lines[i];
            for(int j=line.length();j>0;--j) {
                char c = line.charAt(j-1);
                if(c != '\n' && c != '\r' && c != ' ') {
                    line = line.substring(0, j);
                    break;
                }
            }
            lines[i] = line;
        }
        for(String line : lines) {
            for(int i=1;i<line.length()&&i<indentation;++i)
                if(line.charAt(i) != ' ') {
                    indentation = i;
                    break;
                }
        }
        for(int i=0;i<lines.length;++i) {
            String line = lines[i];
            lines[i] = indentation > line.length() ? "" : line.substring(indentation);
        }
    }

    @Override
    public void toHtml(HtmlUnparsingContext context) {
        context.clear();
        StringBuilder b = context.getStringBuilder();
        b.append("<pre>\n");
        for(String line : lines)
            b.append(line).append('\n');
        b.append("</pre>\n");
    }

}
