package org.simantics.scl.compiler.internal.parsing.declarations;

import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;

public class DValueTypeAst extends DeclarationAst {
    public final EVar[] names;
    public final TypeAst type;
    
    public DValueTypeAst(EVar[] names, TypeAst type) {
        this.names = names;
        this.type = type;
    }
    
    @Override
    public void toString(int indentation, StringBuilder b) {
        for(int i=0;i<indentation;++i) b.append("    ");
        for(int i=0;i<names.length;++i) {
            if(i > 0)
                b.append(", ");
            b.append(names[i]);
        }
        b.append(" :: ");
        type.toString(b);
    }
}
