package org.simantics.scl.compiler.internal.parsing.declarations;

import java.util.ArrayList;

import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;

public class DInstanceAst extends DeclarationAst {
    public final TypeAst[] context;
    public final EVar name;
    public final TypeAst[] types;
    public final DeclarationAst[] declarations;
    
    public DInstanceAst(long loc, TypeAst[] context, EVar name, TypeAst[] types) {
        this.location = loc;
        this.context = context;
        this.name = name;
        this.types = types;
        this.declarations = DeclarationAst.EMPTY_ARRAY;
    }

    public DInstanceAst(ArrayList<TypeAst> context, EVar name, 
            TypeAst[] types, ArrayList<DeclarationAst> declarations) {
        this.context = context.toArray(new TypeAst[context.size()]);
        this.name = name;
        this.types = types;
        this.declarations = declarations == null ? EMPTY_ARRAY : declarations.toArray(new DeclarationAst[declarations.size()]);
    }
    
    @Override
    public void toString(int indentation, StringBuilder b) {
        for(int i=0;i<indentation;++i) b.append("    ");
        b.append("instance ");
        if(context.length > 0) {
            b.append("(");
            for(int i=0;i<context.length;++i) {
                if(i>0)
                    b.append(", ");
                context[i].toString(b);
            }
            b.append(") => ");
            
        }
        b.append(name);
        for(TypeAst type : types) {
            b.append(' ');
            type.toString(b, 1);
        }
        if(declarations.length > 0) {
            b.append(" where");
            for(DeclarationAst declaration : declarations) {
                b.append('\n');
                declaration.toString(indentation+1, b);
            }
        }
    }
}
