package org.simantics.scl.compiler.internal.parsing.declarations;

import java.util.ArrayList;


public class DImportJavaAst extends DeclarationAst {
    
    public final String className;
    public final ArrayList<DeclarationAst> declarations;

    public DImportJavaAst(String className,
            ArrayList<DeclarationAst> declarations) {
        this.className = className;
        this.declarations = declarations;
    }

    @Override
    public void toString(int indentation, StringBuilder b) {
        for(int i=0;i<indentation;++i) b.append("    ");
        b.append("importJava \"");
        b.append(className);
        b.append("\" where\n");
        for(DeclarationAst declaration : declarations)
            declaration.toString(indentation+1, b);
    }
}
