package org.simantics.scl.compiler.internal.parsing.declarations;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.simantics.scl.compiler.internal.parsing.types.TypeAst;


public class DClassAst extends DeclarationAst {
    public final TypeAst[] context;
    public final String name;
    public final String[] parameters;
    public final FundepAst[] fundeps;
    public final DeclarationAst[] declarations;
    
    private List<DAnnotationAst> annotations = Collections.emptyList();
    
    public DClassAst(ArrayList<TypeAst> context, String name,
            String[] parameters, 
            FundepAst[] fundeps,
            ArrayList<DeclarationAst> declarations) {
        this.context = context.toArray(new TypeAst[context.size()]);
        this.name = name;
        this.parameters = parameters;
        this.fundeps = fundeps;
        this.declarations = declarations == null ? EMPTY_ARRAY : declarations.toArray(new DeclarationAst[declarations.size()]);
    }
    
    @Override
    public void toString(int indentation, StringBuilder b) {
        for(int i=0;i<indentation;++i) b.append("    ");
        b.append("class ");
        if(context.length > 0) {
            b.append("(");
            for(int i=0;i<context.length;++i) {
                if(i>0)
                    b.append(", ");
                context[i].toString(b);
            }
            b.append(") => ");
            
        }
        b.append(name);
        for(String parameter : parameters) {
            b.append(' ');
            b.append(parameter);
        }
        if(declarations.length > 0) {
            b.append(" where");
            for(DeclarationAst declaration : declarations) {
                b.append('\n');
                declaration.toString(indentation+1, b);
            }
        }
    }

    public void setAnnotations(List<DAnnotationAst> annotations) {
        this.annotations = annotations;
    }
    
    public List<DAnnotationAst> getAnnotations() {
        return annotations;
    }
}
