package org.simantics.scl.compiler.internal.interpreted;


public class ILet implements IExpression {
    private final int variableId;
    private final IExpression value;
    private final IExpression in;

    public ILet(int variableId, IExpression value, IExpression in) {
        this.variableId = variableId;
        this.value = value;
        this.in = in;
    }

    @Override
    public Object execute(Object[] variableBindings) {
        variableBindings[variableId] = value.execute(variableBindings);
        try {
            return in.execute(variableBindings);
        } finally {
            variableBindings[variableId] = null;
        }
    }
    
    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(let v");
        b.append(variableId);
        b.append(" = ");
        b.append(value);
        b.append(" in ");
        b.append(in);
        b.append(')');
        return b.toString();
    }
}
